import { FieldValues, FormProvider } from 'react-hook-form';

import type { IFormProps } from './form.types';

export function Form<TFieldValues extends FieldValues>({
    children,
    id,
    testId = id && `form-${id}`,
    form,
    onSubmit,
    onError,
    ...props
}: IFormProps<TFieldValues>) {
    return (
        <form data-testid={testId} onSubmit={form.handleSubmit(onSubmit, onError)} {...props}>
            <FormProvider {...form}>{children}</FormProvider>
        </form>
    );
}
