import { ReactNode } from 'react';
import { FieldValues, SubmitErrorHandler, SubmitHandler, UseFormReturn } from 'react-hook-form';

import { ISharedHtmlAtomProps, PropsOf } from '@yandex-travel/ui/types';

export interface IFormProps<TFieldValues extends FieldValues>
    extends ISharedHtmlAtomProps,
        Omit<PropsOf<'form'>, 'onSubmit' | 'onError'> {
    form: UseFormReturn<TFieldValues>;
    onError?: SubmitErrorHandler<TFieldValues>;
    onSubmit: SubmitHandler<TFieldValues>;
    children: NonNullable<ReactNode>;
}
