import { useController } from 'react-hook-form';
import { cloneElement, memo } from 'react';
import { FieldLayout } from '@yandex-travel/ui/molecules';

import type { IFieldProps } from './field.types';

export const Field = memo(
    ({
        label,
        name,
        children,

        id = name,
        className,
        description,
        required = false,
        minLength,
        defaultValue,
        shouldUnregister,
    }: IFieldProps) => {
        const {
            fieldState: { error },
            field,
        } = useController({
            name,
            rules: {
                required: required && {
                    value: true,
                    message: 'Field is required',
                },
                minLength,
            },
            defaultValue,
            shouldUnregister,
        });
        const invalid = Boolean(error);

        return (
            <FieldLayout
                label={label}
                id={id}
                invalid={invalid}
                required={required}
                className={className}
                description={error?.message ?? description}
            >
                {cloneElement(children, {
                    id,
                    invalid,
                    placeholder: children.props.placeholder ?? 'Введите значение',
                    ...field,
                })}
            </FieldLayout>
        );
    },
);
