const typescript = require('@rollup/plugin-typescript');
const { defineConfig } = require('rollup');
const bundleSize = require('rollup-plugin-bundle-size');
const { default: dts } = require('rollup-plugin-dts');
const { default: esbuild } = require('rollup-plugin-esbuild');
const { terser } = require('rollup-plugin-terser');

function bundle(input, { plugins = [], enableBundleSize = true, ...config }) {
    return defineConfig({
        ...config,
        input,
        plugins: plugins.filter(Boolean).concat(enableBundleSize ? bundleSize() : []),
        // do not bundle packages
        external: id => !/^[./]/.test(id),
    });
}

module.exports = function createRollupConfig({
    enableBundleSize = true,
    transpileOnly = true,
    minify = false,
    packageJson: { main, module, types, source },
}) {
    return defineConfig([
        /* Compiled JS (CommonJS, ESM) */
        bundle(source, {
            enableBundleSize,
            plugins: [!transpileOnly && typescript(), esbuild(), minify && terser()],
            output: [
                {
                    file: main,
                    format: 'cjs',
                },
                {
                    file: module,
                    format: 'es',
                },
            ],
        }),

        /* TS declarations */
        bundle(source, {
            enableBundleSize,
            plugins: [dts()],
            output: [
                {
                    file: types,
                    format: 'es',
                },
            ],
        }),
    ]);
};
