const fs = require('fs');

const [source, destination] = process.argv.slice(2);

const swagger = require(source);

const { definitions } = swagger;

let content = JSON.stringify(swagger);

const symbolsMap = {
    А: 'A',
    а: 'a',
    Б: 'B',
    б: 'b',
    В: 'V',
    в: 'v',
    Г: 'G',
    г: 'g',
    Д: 'D',
    д: 'd',
    Е: 'E',
    е: 'e',
    Ё: 'Yo',
    ё: 'yo',
    Ж: 'Zh',
    ж: 'zh',
    З: 'Z',
    з: 'z',
    И: 'I',
    и: 'i',
    Й: 'J',
    й: 'j',
    К: 'K',
    к: 'k',
    Л: 'L',
    л: 'l',
    М: 'M',
    м: 'm',
    Н: 'N',
    н: 'n',
    О: 'O',
    о: 'o',
    П: 'P',
    п: 'p',
    Р: 'R',
    р: 'r',
    С: 'S',
    с: 's',
    Т: 'T',
    т: 't',
    У: 'U',
    у: 'u',
    Ф: 'F',
    ф: 'f',
    Х: 'X',
    х: 'x',
    Ц: 'C',
    ц: 'c',
    Ч: 'Ch',
    ч: 'ch',
    Ш: 'Sh',
    ш: 'sh',
    Щ: 'Shh',
    щ: 'shh',
    Ъ: '',
    ъ: '',
    Ы: 'Y',
    ы: 'y',
    Ь: '',
    ь: '',
    Э: 'E',
    э: 'e',
    Ю: 'Yu',
    ю: 'yu',
    Я: 'Ya',
    я: 'ya',
    ' ': '_',
};
const symbolsPairs = Object.entries(symbolsMap);

for (const key of Object.keys(definitions)) {
    if (/[ЁёА-я]/.test(key)) {
        const transliteratedKey = symbolsPairs.reduce(
            (acc, [ru, en]) => acc.replace(new RegExp(`${ru}`, 'g'), en),
            key,
        );

        console.log(`[replace] "${key}" -> "${transliteratedKey}"`);
        content = content
            .replaceAll(new RegExp(`"${key}":`, 'g'), `"${transliteratedKey}":`)
            .replaceAll(new RegExp(`${key}`, 'g'), `${transliteratedKey}`);
    }
}

const parsedContent = JSON.parse(content);

fs.writeFileSync(destination, JSON.stringify(parsedContent, null, 2), 'utf8');
