module.exports = {
    async prompt({ prompter, args }) {
        const { url } = await prompter.prompt({
            type: 'input',
            name: 'url',
            skip: Boolean(args.silent),
            initial: args.url,
            message: 'URL с конфигурацией сваггера',
        });
        const { out } = await prompter.prompt({
            type: 'input',
            name: 'out',
            skip: Boolean(args.silent),
            initial: args.out,
            message: 'Директория с результатами',
        });
        const { name } = await prompter.prompt({
            type: 'input',
            name: 'name',
            skip: Boolean(args.silent),
            initial: args.name || 'api.gen.ts',
            message: 'Имя сгенерированного файла',
        });

        return {
            url,
            out,
            name,
        };
    },
};
