const { readdir } = require('fs/promises');
const { resolve } = require('path');

const { ArgumentsStore } = require('../../../internal');

module.exports = {
    async prompt({ prompter, args }) {
        const store = new ArgumentsStore('dev-local-domain', {
            domain: args.domain,
            port: args.port ?? 3000,
        });
        const domains = await readdir(resolve(__dirname, 'domains'));
        const initial = await store.get();

        initial.domain = domains.includes(initial.domain) ? initial.domain : undefined;

        const { domain } = await prompter.prompt({
            name: 'domain',
            type: 'select',
            skip: Boolean(args.silent && initial.domain),
            initial: initial.domain,
            choices: domains,
        });
        const { port } = await prompter.prompt({
            name: 'port',
            type: 'input',
            skip: Boolean(args.silent && initial.port),
            initial: initial.port,
            message: 'Порт вашего localhost-приложения',
        });

        await store.set({
            domain,
            port,
        });

        return {
            domain,
            port,
        };
    },
};
