const { readFile, readdir } = require('fs/promises');
const { join } = require('path');

const { ArgumentsStore } = require('../../../internal');

module.exports = {
    async prompt({ prompter, args }) {
        const store = new ArgumentsStore('dev-local-tvm', {
            template: args.template,
            secret: args.secret,
        });
        const templates = await readdir(join(__dirname, 'templates'));
        const initial = await store.get();

        initial.template = templates.includes(initial.template) ? initial.template : null;

        const { template } = await prompter.prompt({
            type: 'select',
            name: 'template',
            skip: Boolean(args.silent && initial.template),
            initial: initial.template,
            message: 'Выберите шаблон',
            choices: templates,
        });

        const contentAsString = await readFile(join(__dirname, 'templates', template));
        const tvm = JSON.parse(contentAsString);

        const { port } = await prompter.prompt({
            type: 'input',
            name: 'port',
            skip: Boolean(args.silent),
            initial: tvm.port,
            message: 'TVM Порт',
        });
        const { name } = await prompter.prompt({
            type: 'input',
            name: 'name',
            skip: Boolean(args.silent),
            initial: 'app',
            message: 'Имя вашего приложения',
        });
        const { id } = await prompter.prompt({
            type: 'input',
            name: 'id',
            skip: Boolean(args.silent),
            initial: tvm.clients.app.self_tvm_id,
            message: 'ID вашего приложения (tvm self id)',
        });
        const { secret } = await prompter.prompt({
            type: 'input',
            name: 'secret',
            skip: Boolean(args.silent && initial.secret),
            initial: initial.secret,
            message: 'Токен авторизации (из https://yav.yandex-team.ru)',
        });

        await store.set({
            template,
            secret,
        });

        return {
            id,
            port,
            name,
            secret,
            destinations: Object.entries(tvm.clients.app.dsts).map(([name, { dst_id }]) => ({
                name,
                id: dst_id,
            })),
            template,
            config: {
                // TODO Добавить выбор blackbox
                BbEnvType: 2,
                clients: {
                    [name]: {
                        secret: secret,
                        self_tvm_id: 2034601,
                        dsts: tvm.clients.app.dsts,
                    },
                },
                port: Number(port),
                backends: null,
            },
        };
    },
};
