const { ArgumentsStore } = require('../../../internal');

module.exports = {
    async prompt({ prompter, args }) {
        const store = new ArgumentsStore('dev-remote-blackbox', {
            domain: args.domain,
            blackboxDomain: args.blackboxDomain,
        });
        const initial = await store.get();

        const { domain } = await prompter.prompt({
            name: 'domain',
            type: 'input',
            skip: Boolean(args.silent && initial.domain),
            initial: initial.domain,
        });
        const { blackboxDomain } = await prompter.prompt({
            name: 'blackboxDomain',
            type: 'select',
            skip: Boolean(args.silent && initial.blackboxDomain),
            initial: initial.blackboxDomain,
            message: 'Тип BlackBox',
            choices: ['https://blackbox.yandex-team.ru'],
        });

        await store.set({
            domain,
            blackboxDomain,
        });

        return {
            domain,
            blackboxDomain,
        };
    },
};
