const tailwindcssColors = require('tailwindcss/colors');

/**
 * ОБЩЕЕ
 * Идентификаторы размеров изменены для согласованности с темой tailwind
 * s -> sm, m -> md, s -> sm
 * Нейминг цветов согласован с дизайн токенами за исключением:
 * - border-focused-color переименован в ring (ex: border-xxx-primary-focused-color -> colors: { xxx: { primary: { ring: ... } } })
 */

const lineHeight = {
    xxs: '14px',
    xs: '16px',
    sm: '18px',
    md: '20px',
    lg: '22px',
    xl: '26px',
    xxl: '38px',
};
/**
 * Цвета
 * @see https://www.figma.com/file/I8EBpOVkBHKTHVrDyWuaaIhI/Travel.Styles?node-id=29417%3A5056
 */
const coreColors = {
    yellow: '#FED42B',
    grey: {
        dark: '#333333',
        light: '#9D9B98',
    },
    blue: '#004ED8',
    red: '#FF0000',
    brown: '#CC6600',
    green: '#009900',
    highlight: '#FFEBA0',
};
const textColors = {
    primary: coreColors.grey.dark,
    secondary: coreColors.grey.light,
    inverse: tailwindcssColors.white,
    alert: coreColors.red,
    highlight: coreColors.brown,
    success: coreColors.green,
    /**
     * @see https://tailwindcss.com/docs/gradient-color-stops
     */
    plus: {
        from: '#FA6641',
        via: '#BE40C0',
        to: '#505ADD',
    },
    plusCounter: {
        from: '#7F45D1',
        to: '#397DDB',
    },
    disabled: '#9D9B9899',
};
const linkColors = {
    primary: coreColors.blue,
    light: '#004ED899',
    black: textColors.primary,
    ghost: textColors.secondary,
    yellow: coreColors.yellow,
    inverse: textColors.inverse,
    hover: coreColors.red,
    disabled: textColors.disabled,
};
const labelColors = {
    neutral: '#E9ECEF',
    primary: '#00BF27',
    secondary: '#267EFF',
    alert: '#FF3333',
    inverse: coreColors.grey.dark,
    active: coreColors.yellow,
    light: tailwindcssColors.white,
};
const fillColors = {
    primary: tailwindcssColors.white,
    secondary: '#F5F4F2',
    warning: {
        DEFAULT: labelColors.neutral,
        success: '#00BF271F',
        highlight: '#FFEBA0',
        attention: '#FF33331F',
    },
    picture: {
        primary: '#3333330D',
    },
    modal: '#00000066',
    loader: '#FFFFFFE5',
    imagesViewer: '#1A1A1CE5',
};
const controlColors = {
    disabled: '#F1F0ED',
    primary: coreColors.yellow,
    border: '#E3E1DC',
};
const buttonSharedColors = {
    primary: coreColors.yellow,
    pressed: '#D2D0CB',
    alert: 'rgba(255, 0, 0, 0.1)',
};
const buttonColors = {
    ring: buttonSharedColors.primary,
    primary: {
        DEFAULT: buttonSharedColors.primary,
        hover: '#F2C200',
        active: '#F2C200',
        focused: buttonSharedColors.primary,
        ring: '#B38F00',
    },
    secondary: {
        DEFAULT: controlColors.disabled,
        hover: '#EBE9E4',
        active: '#EBE9E4',
        focused: controlColors.disabled,
    },
    outlined: {
        ring: '#E3E1DC',
        'ring-hover': '#DBD9D3',
    },
    pressed: {
        DEFAULT: buttonSharedColors.pressed,
        hover: '#C9C6C0',
        active: '#C9C6C0',
        focused: buttonSharedColors.pressed,
    },
    alert: {
        DEFAULT: buttonSharedColors.alert,
        hover: 'rgba(255, 0, 0, 0.15)',
        active: 'rgba(255, 0, 0, 0.15)',
        focused: buttonSharedColors.alert,
        ring: coreColors.red,
    },
    floated: {
        DEFAULT: tailwindcssColors.white,
    },
    light: {
        DEFAULT: tailwindcssColors.white,
    },
    plus: {
        // TODO
    },
};
const radioColors = {
    DEFAULT: buttonColors.secondary.DEFAULT,
    selected: tailwindcssColors.white,
    hover: buttonColors.secondary.hover,
    active: buttonColors.secondary.active,
    focused: buttonColors.secondary.DEFAULT,
    ring: {
        DEFAULT: buttonColors.ring,
        error: coreColors.red,
    },
};

const checkboxColors = {
    DEFAULT: tailwindcssColors.white,
    disabled: '#F1F0ED',
    active: '#FFEBA0',
    border: {
        DEFAULT: '#E3E1DC',
        hover: '#C9C6C0',
        focused: buttonColors.ring,
    },
};

const checkboxPressedColors = {
    DEFAULT: '#FFEBA0',
    hover: '#F7D65F',
    active: '#F2C200',
    border: {
        DEFAULT: '#FFEBA0',
        hover: '#F7D65F',
        active: '#F2C200',
        focused: buttonColors.primary.ring,
    },
};
/**
 * TODO
 * Кнопка Плюса
 * Интент
 * Контурные контролы
 * Диапазон
 * Дизейбл состояние кнопок
 * Suggest
 * Label colors
 * Rating colors
 * Pin colors
 * Train scheme colors
 * Promo Colors
 */

module.exports = {
    /**
     * @param {string[]} dependencies
     * @returns {import('tailwindcss/tailwind-config').TailwindConfig}
     */
    createTailwindConfig({ dependencies = [] }) {
        return {
            content: ['.', ...dependencies].flatMap(prefix => `${prefix}/**/*.{ts,tsx,mdx}`),
            theme: {
                colors: {
                    transparent: 'transparent',
                    current: 'currentColor',
                    black: tailwindcssColors.black,
                    white: tailwindcssColors.white,
                    ...coreColors,
                    text: textColors,
                    link: linkColors,
                    fill: fillColors,
                    label: labelColors,
                    radio: radioColors,
                    button: buttonColors,
                    control: controlColors,
                    checkbox: checkboxColors,
                    checkboxPressed: checkboxPressedColors,
                },
                screens: {
                    desktop: '1240px',
                    touch: '632px',
                    lg: '1240px',
                    md: '632px',
                    sm: '360px',
                    xs: '320px',
                },
                /**
                 * @see https://www.figma.com/file/I8EBpOVkBHKTHVrDyWuaaIhI/Travel.Styles?node-id=4169%3A1
                 */
                fontSize: {
                    xxs: '10px',
                    xs: '11px',
                    sm: '13px',
                    md: '15px',
                    lg: '18px',
                    xl: '22px',
                    xxl: '32px',
                    base: '1rem',
                },
                borderRadius: {
                    xs: '4px',
                    sm: '8px',
                    DEFAULT: '12px',
                    md: '16px',
                    lg: '20px',
                    full: '9999px',
                },
                spacing: {
                    xs: '4px',
                    sm: '8px',
                    md: '12px',
                    lg: '16px',
                    xl: '20px',
                    xxl: '24px',
                    xxxl: '28px',
                    xxxxl: '40px',
                    xxxxxl: '60px',
                    // TODO Что-то сделать с этим
                    ...Object.fromEntries(
                        Array.from(
                            {
                                length: 200,
                            },
                            (_, index) => index,
                        )
                            .flatMap(index => [index, index + 0.5])
                            .map(index => [index, `${index * 4}px`]),
                    ),
                },
                lineHeight,
                boxShadow: {
                    navigation: '0px 4px 12px -4px rgba(13, 35, 67, 0.15)',
                    object: '0px 4px 12px -4px rgba(13, 35, 67, 0.15), 0px 0px 2px rgba(13, 35, 67, 0.15)',
                    obj: '0px 4px 12px -4px rgba(13, 35, 67, 0.15), 0px 0px 2px rgba(13, 35, 67, 0.15)',
                    'obj-hover':
                        '0px 6px 16px -4px rgba(13, 35, 67, 0.2), 0px 0px 2px rgba(13, 35, 67, 0.3)',
                    'obj-active':
                        '0px 0px 2px 0px rgba(13, 35, 67, 0.1), 0px 1px 1px 0px rgba(13, 35, 67, 0.2)',
                    popup: '0px 5px 20px -5px rgba(13, 35, 67, 0.2), 0px 10px 40px -5px rgba(13, 35, 67, 0.2)',
                    'button-hover':
                        '0px 6px 16px -4px rgba(13, 35, 67, 0.2), 0px 0px 2px rgba(13, 35, 67, 0.3)',
                    'button-active':
                        '0px 0px 2px 0px rgba(13, 35, 67, 0.1), 0px 1px 1px 0px rgba(13, 35, 67, 0.2)',
                },
                fontFamily: {
                    sans: 'YS Text, ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";',
                },
            },
            plugins: [],
        };
    },
};
