/**
 * Пресет, идентичный @yandex-travel/eslint-config
 * Используйте для постепенного перехода
 */
module.exports = {
    extends: ['eslint:recommended', 'prettier'],
    parser: '@babel/eslint-parser',
    parserOptions: {
        ecmaVersion: 2019,
        requireConfigFile: false,
    },
    env: {
        es6: true,
        'shared-node-browser': true,
    },
    plugins: ['import-helpers'],
    rules: {
        // Possible Errors
        'no-empty': 'off', // eslint:recommended
        'valid-jsdoc': [
            'warn',
            { requireParamDescription: false, requireReturnDescription: false },
        ],

        // Best Practices
        'array-callback-return': 'error',
        'block-scoped-var': 'warn',
        complexity: 'warn',
        'dot-location': ['error', 'property'],
        eqeqeq: ['warn', 'always'],
        'guard-for-in': 'error',
        'no-caller': 'error',
        'no-div-regex': 'warn',
        'no-eq-null': 'error',
        'no-eval': 'warn',
        'no-extend-native': 'error',
        'no-extra-bind': 'warn',
        'no-extra-label': 'error',
        'no-floating-decimal': 'error',
        'no-global-assign': 'warn', // eslint:recommended
        'no-implicit-coercion': 'warn',
        'no-implicit-globals': 'warn',
        'no-implied-eval': 'warn',
        'no-iterator': 'error',
        'no-labels': 'error',
        'no-loop-func': 'error',
        'no-new': 'error',
        'no-new-func': 'warn',
        'no-new-wrappers': 'error',
        'no-octal-escape': 'error',
        'no-param-reassign': 'warn',
        'no-proto': 'error',
        'no-return-assign': ['error', 'always'],
        'no-script-url': 'error',
        'no-self-compare': 'error',
        'no-sequences': 'error',
        'no-throw-literal': 'warn',
        'no-unmodified-loop-condition': 'error',
        'no-unused-expressions': 'error',
        'no-useless-call': 'error',
        'no-useless-concat': 'error',
        'no-void': 'error',
        'no-with': 'error',
        radix: 'warn',
        'wrap-iife': ['error', 'inside'],
        'comma-dangle': ['warn', 'always-multiline'],
        'no-else-return': 'error',
        'no-mixed-operators': [
            'error',
            {
                groups: [['&&', '||']],
            },
        ],

        // Variables
        'no-label-var': 'error',
        'no-shadow': 'warn',
        'no-shadow-restricted-names': 'error',
        'no-undef-init': 'error',
        'no-use-before-define': ['warn', { functions: false }],

        // Node.js and CommonJS
        'callback-return': 'warn',
        'handle-callback-err': 'warn',
        'no-new-require': 'error',
        'no-path-concat': 'warn',

        // Stylistic Issues
        camelcase: ['warn', { properties: 'never' }],
        'comma-style': ['error', 'last'],
        'max-depth': ['warn', { maximum: 5 }],
        'new-cap': 'error',
        'new-parens': 'error',
        'no-array-constructor': 'warn',
        'no-bitwise': 'error',
        'no-lonely-if': 'warn',
        'no-negated-condition': 'warn',
        'no-nested-ternary': 'warn',
        'no-new-object': 'warn',
        'no-restricted-syntax': ['error', 'WithStatement'],
        'no-unneeded-ternary': 'error',

        // ECMAStrict 6
        'no-duplicate-imports': 'error',
        'no-useless-constructor': 'error',
        'no-var': 'error',
        'prefer-arrow-callback': ['warn', { allowNamedFunctions: true }],
        'prefer-const': 'error',
        'prefer-rest-params': 'error',
        'prefer-spread': 'error',
        'require-atomic-updates': 'off', // eslint:recommended
        'require-yield': 'warn', // eslint:recommended

        'padding-line-between-statements': [
            'warn',
            {
                blankLine: 'always',
                prev: ['return', 'block', 'block-like', 'break', 'continue'],
                next: '*',
            },
            {
                blankLine: 'always',
                prev: '*',
                next: ['return', 'block', 'block-like', 'break', 'continue'],
            },
            {
                blankLine: 'always',
                prev: ['const', 'let', 'var'],
                next: '*',
            },
            {
                blankLine: 'always',
                prev: '*',
                next: ['const', 'let', 'var'],
            },
            {
                blankLine: 'any',
                prev: ['const', 'let', 'var'],
                next: ['const', 'let', 'var'],
            },
            {
                blankLine: 'any',
                prev: 'case',
                next: 'case',
            },
            {
                blankLine: 'always',
                prev: 'import',
                next: '*',
            },
            {
                blankLine: 'always',
                prev: '*',
                next: 'import',
            },
            {
                blankLine: 'any',
                prev: 'import',
                next: 'import',
            },
        ],

        // order
        'import-helpers/order-imports': [
            'error',
            {
                newlinesBetween: 'always',
                // Массив ниже предопределяет группы, на которые должны быть разделены импорты.
                // Проверка происходит по принципу подхождения пути импорта под регулярное выражение.
                groups: [
                    // Сначала внешние модули
                    'module',
                    // Клиентский корневой импорт
                    '/prerequisites/',
                    // Константы. Лежат в подпапках или файлах constants
                    '/constants/',
                    // Типы и интерфейсы. Лежат в подпапках и файлах type или types
                    '/(/|^)types?(/|$)/',
                    '/^reducers/',
                    '/selectors/',
                    '/^sagas/',
                    // Вспомогательные функции. Лежат в подпапках и файлах lib|helpers|utilities|utils
                    '/(lib|helpers|utilities|utils)/',
                    // Переводы
                    '/^(i18nNew|i18n)/',
                    '/^(hooks)/',
                    '/^containers/',
                    // Компоненты. Лежат в попапках и файлах components|icons
                    '/(^icons|components)/',
                    '/^projects/',
                    '/^contexts/',
                    '/^server/',
                    '/^serviceProvider/',
                    // Картинки
                    '/^images/',
                    // Относительные пути
                    ['parent', 'sibling', 'index'],
                    // Пути до стилей
                    '/\\.scss$/',
                ],
            },
        ],

        // Отключаем prettier чтобы в процессе работы не было постоянной подсветки:
        // - форматирование должно быть на коммит
        // - проверка, что форматирование не пропустили в проверке на PR (prettier --check)
        'prettier/prettier': 'off',
    },

    overrides: [
        {
            files: ['*.ts'],
            parser: '@typescript-eslint/parser',
            parserOptions: {
                sourceType: 'module',
            },
            plugins: ['@typescript-eslint'],
            rules: {
                // For tsx, the react/sort-comp rule is used is client
                '@typescript-eslint/member-ordering': [
                    'error',
                    {
                        default: [
                            'public-static-field',
                            'protected-static-field',
                            'private-static-field',

                            'public-static-method',
                            'protected-static-method',
                            'private-static-method',

                            'public-instance-field',
                            'protected-instance-field',
                            'private-instance-field',

                            'constructor',

                            'public-instance-method',
                            'protected-instance-method',
                            'private-instance-method',
                        ],
                    },
                ],
            },
        },
        {
            files: ['*.ts', '*.tsx'],
            parser: '@typescript-eslint/parser',
            parserOptions: {
                sourceType: 'module',
            },
            plugins: ['@typescript-eslint'],
            rules: {
                // TypeScript compiler handles these on its own
                strict: 'off',
                'no-undef': 'off',
                'no-dupe-class-members': 'off',
                'valid-jsdoc': 'off',

                // TypeScript-specific extension rules
                'no-array-constructor': 'off',
                'no-duplicate-imports': 'off',
                'no-loop-func': 'off',
                'no-redeclare': 'off',
                'no-shadow': 'off',
                'no-unused-expressions': 'off',
                'no-unused-vars': 'off', // Disable because we use an analogue @typescript-eslint/no-unused-vars
                'no-use-before-define': 'off',
                'no-useless-constructor': 'off',
                '@typescript-eslint/no-array-constructor': 'warn',
                '@typescript-eslint/no-duplicate-imports': 'error',
                '@typescript-eslint/no-loop-func': 'error',
                '@typescript-eslint/no-redeclare': 'error',
                '@typescript-eslint/no-shadow': 'warn',
                '@typescript-eslint/no-unused-expressions': 'error',
                '@typescript-eslint/no-unused-vars': [
                    'error',
                    {
                        ignoreRestSiblings: true,
                        argsIgnorePattern: '^_',
                    },
                ],
                '@typescript-eslint/no-use-before-define': ['warn', { functions: false }],
                '@typescript-eslint/no-useless-constructor': 'error',
                '@typescript-eslint/explicit-function-return-type': [
                    'error',
                    {
                        allowTypedFunctionExpressions: true,
                    },
                ],
                '@typescript-eslint/array-type': [
                    'error',
                    {
                        default: 'array',
                    },
                ],

                '@typescript-eslint/naming-convention': [
                    'error',
                    {
                        selector: 'interface',
                        format: ['PascalCase'],
                        prefix: ['I'],
                    },
                    {
                        selector: 'typeAlias',
                        format: ['PascalCase'],
                        prefix: ['T'],
                    },
                    {
                        selector: 'enum',
                        format: ['PascalCase'],
                        prefix: ['E'],
                    },
                    {
                        selector: 'enumMember',
                        format: ['UPPER_CASE'],
                    },
                ],
                '@typescript-eslint/member-delimiter-style': 'error',
                '@typescript-eslint/explicit-member-accessibility': [
                    'error',
                    { accessibility: 'no-public' },
                ],
                '@typescript-eslint/consistent-type-assertions': 'error',
                '@typescript-eslint/no-explicit-any': 'warn',
                '@typescript-eslint/no-namespace': 'error',
                '@typescript-eslint/no-non-null-assertion': 'warn',
                '@typescript-eslint/no-parameter-properties': 'error',
                '@typescript-eslint/triple-slash-reference': 'error',
                '@typescript-eslint/prefer-namespace-keyword': 'error',
                '@typescript-eslint/no-inferrable-types': [
                    'error',
                    {
                        ignoreParameters: true,
                        ignoreProperties: true,
                    },
                ],
                '@typescript-eslint/type-annotation-spacing': [
                    'error',
                    {
                        before: true,
                        after: true,
                        overrides: {
                            colon: {
                                before: false,
                            },
                        },
                    },
                ],
            },
        },
    ],
};
