const { compilePresets, mergeConfig, PresetsPriority } = require('./lib');

const presets = require('./presets');

const { applyModuleResolutionPatch } = require('./lib/module-resolution-patch');

function createConfig({ root = process.cwd(), presets: includedPresets, extend = {} }) {
    const config = compilePresets(includedPresets, PresetsPriority, { root });

    applyModuleResolutionPatch(config);

    const extendedConfig = compilePresets([presets.extend(extend)], PresetsPriority);

    return mergeConfig([config, extendedConfig]);
}

module.exports = {
    presets,
    createConfig,
};
