const { mergeConfig } = require('./merge-config');
const { createPresetsContext } = require('./create-preset');

function compilePresets(presets, priority, options = {}) {
    const prioritized = presets
        .slice()
        .sort((a, b) => priority.indexOf(a.name) - priority.indexOf(b.name));

    const context = createPresetsContext(options);

    for (const preset of prioritized) {
        context.presets.add(preset.name);
        preset.context({ context, options: preset.options });
    }

    const configs = prioritized.map(preset => preset.config({ context, options: preset.options }));

    return mergeConfig(configs);
}

module.exports = {
    compilePresets,
};
