const PresetsNames = {
    base: 'base',
    extend: 'extend',

    imports: 'imports',
    node: 'node',
    prettier: 'prettier',
    typescript: 'typescript',
    fsd: 'fsd',
    react: 'react',
    effector: 'effector',
    nextJs: 'next.js',
};

const PresetsPriority = [
    // should be applied first
    'base',
    'imports',
    'typescript',

    'prettier',
    'fsd',
    'node',
    'react',

    // apply after react preset
    'next.js',

    // may need next.js integration in future
    'effector',

    // should be applied last
    'extend',
];

const MISC = ['.json'];
const JS = ['.js', '.mjs', '.jsx'];
const TS = ['.ts', '.tsx', '.d.ts'];

const Extensions = {
    JS,
    TS,
    MISC,
    JS_AND_TS: [...JS, ...TS],
};

module.exports = {
    PresetsPriority,
    PresetsNames,
    Extensions,
};
