const noop = () => undefined;

function createPreset({ name, config, context = noop }) {
    return (options = {}) => ({
        name,
        config,
        context,
        options,
    });
}

function createPresetsContext({ root = process.cwd() }) {
    return {
        root,
        readPackageJson: () => null,
        readJsconfig: () => null,
        presets: new Set(),
        imports: {
            extensions: [],
        },
        typescript: {
            root: './',
            tsconfig: 'tsconfig.json',
        },
    };
}

module.exports = {
    createPreset,
    createPresetsContext,
};
