const { createPreset, PresetsNames } = require('../lib');

module.exports = createPreset({
    name: PresetsNames.base,
    config: () => ({
        plugins: ['unicorn', 'sonarjs'],
        env: {
            es6: true,
        },
        parser: '@babel/eslint-parser',
        parserOptions: {
            requireConfigFile: false,
            ecmaVersion: 2018,
            sourceType: 'module',
        },
        rules: {
            // === our rules ===

            // Possible Errors
            'no-empty': 'off', // eslint:recommended
            'valid-jsdoc': [
                'warn',
                { requireParamDescription: false, requireReturnDescription: false },
            ],

            // Best Practices
            'array-callback-return': 'error',
            'block-scoped-var': 'warn',
            complexity: 'warn',
            'dot-location': ['error', 'property'],
            eqeqeq: ['warn', 'always'],
            'guard-for-in': 'error',
            'no-caller': 'error',
            'no-div-regex': 'warn',
            'no-eq-null': 'error',
            'no-eval': 'warn',
            'no-extend-native': 'error',
            'no-extra-bind': 'warn',
            'no-extra-label': 'error',
            'no-floating-decimal': 'error',
            'no-global-assign': 'warn', // eslint:recommended
            'no-implicit-coercion': 'warn',
            'no-implicit-globals': 'warn',
            'no-implied-eval': 'warn',
            'no-iterator': 'error',
            'no-labels': 'error',
            'no-loop-func': 'error',
            'no-new': 'error',
            'no-new-func': 'warn',
            'no-new-wrappers': 'error',
            'no-octal-escape': 'error',
            'no-param-reassign': 'warn',
            'no-proto': 'error',
            'no-return-assign': ['error', 'always'],
            'no-script-url': 'error',
            'no-self-compare': 'error',
            'no-sequences': 'error',
            'no-throw-literal': 'warn',
            'no-unmodified-loop-condition': 'error',
            'no-unused-expressions': 'error',
            'no-useless-call': 'error',
            'no-useless-concat': 'error',
            'no-void': 'error',
            'no-with': 'error',
            radix: 'warn',
            'wrap-iife': ['error', 'inside'],
            'comma-dangle': ['warn', 'always-multiline'],
            'no-else-return': 'error',
            'no-mixed-operators': [
                'error',
                {
                    groups: [['&&', '||']],
                },
            ],

            // Variables
            'no-label-var': 'error',
            'no-shadow': 'warn',
            'no-shadow-restricted-names': 'error',
            'no-undef-init': 'error',
            'no-use-before-define': ['warn', { functions: false }],

            // Node.js and CommonJS
            'callback-return': 'warn',
            'handle-callback-err': 'warn',
            'no-new-require': 'error',
            'no-path-concat': 'warn',

            // Stylistic Issues
            camelcase: ['warn', { properties: 'never' }],
            'comma-style': ['error', 'last'],
            'max-depth': ['warn', { maximum: 5 }],
            'new-cap': 'error',
            'new-parens': 'error',
            'no-array-constructor': 'warn',
            'no-bitwise': 'error',
            'no-lonely-if': 'warn',
            'no-negated-condition': 'warn',
            'no-nested-ternary': 'warn',
            'no-new-object': 'warn',
            'no-restricted-syntax': ['error', 'WithStatement'],
            'no-unneeded-ternary': 'error',

            // ECMAStrict 6
            'no-duplicate-imports': 'error',
            'no-useless-constructor': 'error',
            'no-var': 'error',
            'prefer-arrow-callback': ['warn', { allowNamedFunctions: true }],
            'prefer-const': 'error',
            'prefer-rest-params': 'error',
            'prefer-spread': 'error',
            'require-atomic-updates': 'off', // eslint:recommended
            'require-yield': 'warn', // eslint:recommended

            'padding-line-between-statements': [
                'warn',
                {
                    blankLine: 'always',
                    prev: ['return', 'block', 'block-like', 'break', 'continue'],
                    next: '*',
                },
                {
                    blankLine: 'always',
                    prev: '*',
                    next: ['return', 'block', 'block-like', 'break', 'continue'],
                },
                {
                    blankLine: 'always',
                    prev: ['const', 'let', 'var'],
                    next: '*',
                },
                {
                    blankLine: 'always',
                    prev: '*',
                    next: ['const', 'let', 'var'],
                },
                {
                    blankLine: 'any',
                    prev: ['const', 'let', 'var'],
                    next: ['const', 'let', 'var'],
                },
                {
                    blankLine: 'any',
                    prev: 'case',
                    next: 'case',
                },
                {
                    blankLine: 'always',
                    prev: 'import',
                    next: '*',
                },
                {
                    blankLine: 'always',
                    prev: '*',
                    next: 'import',
                },
                {
                    blankLine: 'any',
                    prev: 'import',
                    next: 'import',
                },
            ],

            // === additional rules from eslint-kit (probably, will be removed) ===

            // eslint error-check rules
            'for-direction': 'error',
            'getter-return': 'error',
            'no-async-promise-executor': 'error',
            'no-compare-neg-zero': 'error',
            'no-cond-assign': 'error',
            'no-constant-condition': 'error',
            'no-control-regex': 'error',
            'no-debugger': 'error',
            'no-dupe-else-if': 'error',
            'no-dupe-keys': 'error',
            'no-duplicate-case': 'error',
            'no-empty-character-class': 'error',
            'no-ex-assign': 'error',
            'no-extra-boolean-cast': 'warn',
            'no-func-assign': 'error',
            'no-inner-declarations': 'error',
            'no-invalid-regexp': 'error',
            'no-irregular-whitespace': 'error',
            'no-misleading-character-class': 'error',
            'no-obj-calls': 'error',
            'no-prototype-builtins': 'warn',
            'no-regex-spaces': 'warn',
            'no-setter-return': 'error',
            'no-sparse-arrays': 'error',
            'no-template-curly-in-string': 'error',
            'no-unexpected-multiline': 'error',
            'no-unreachable': 'error',
            'no-unsafe-finally': 'error',
            'no-unsafe-negation': 'error',
            'use-isnan': 'error',

            // eslint best-practice rules
            'default-case': 'error',
            'dot-notation': 'warn',
            'no-alert': 'warn',
            'no-console': [
                'warn',
                { allow: ['warn', 'error', 'info', 'group', 'groupEnd', 'table'] },
            ],
            'no-case-declarations': 'warn',
            'no-constructor-return': 'warn',
            'no-empty-pattern': 'error',
            'no-fallthrough': 'warn',
            'no-octal': 'error',
            'no-redeclare': 'error',
            'no-return-await': 'warn',
            'no-self-assign': 'error',
            'no-unused-labels': 'error',
            'no-useless-escape': 'warn',
            'no-useless-return': 'warn',
            yoda: 'warn',

            // eslint variable rules
            'no-delete-var': 'error',
            'no-undef': 'error',
            'no-unused-vars': [
                'warn',
                {
                    ignoreRestSiblings: true,
                    varsIgnorePattern: '^_',
                    argsIgnorePattern: '^_',
                },
            ],

            // eslint stylistic rules
            'lines-between-class-members': ['warn', 'always', { exceptAfterSingleLine: true }],
            'operator-assignment': 'warn',
            'prefer-exponentiation-operator': 'warn',

            // eslint es6 rules
            'constructor-super': 'error',
            'no-class-assign': 'error',
            'no-const-assign': 'error',
            'no-dupe-class-members': 'error',
            'no-new-symbol': 'error',
            'no-this-before-super': 'error',
            'no-useless-computed-key': 'warn',
            'no-useless-rename': 'warn',
            'object-shorthand': 'warn',

            // === unicorn ===

            'unicorn/catch-error-name': 'warn',
            'unicorn/error-message': 'warn',
            'unicorn/escape-case': 'warn',
            'unicorn/explicit-length-check': 'warn',
            'unicorn/new-for-builtins': 'error',
            'unicorn/no-abusive-eslint-disable': 'warn',
            'unicorn/no-instanceof-array': 'error',
            'unicorn/no-console-spaces': 'warn',
            'unicorn/no-for-loop': 'warn',
            'unicorn/no-hex-escape': 'warn',
            'unicorn/no-nested-ternary': 'warn',
            'unicorn/no-new-buffer': 'error',
            'unicorn/no-unreadable-array-destructuring': 'warn',
            'unicorn/no-zero-fractions': 'warn',
            'unicorn/number-literal-case': 'warn',
            'unicorn/prefer-add-event-listener': 'error',
            // rule does not exist but listed in docs
            // 'unicorn/prefer-array-find': 'error',
            'unicorn/prefer-dom-node-dataset': 'warn',
            'unicorn/prefer-keyboard-event-key': 'error',
            'unicorn/prefer-array-flat-map': 'warn',
            'unicorn/prefer-includes': 'error',
            'unicorn/prefer-negative-index': 'warn',
            'unicorn/prefer-dom-node-append': 'error',
            'unicorn/prefer-dom-node-remove': 'error',
            'unicorn/prefer-number-properties': ['warn', { checkInfinity: false }],
            'unicorn/prefer-query-selector': 'error',
            'unicorn/prefer-string-starts-ends-with': 'error',
            'unicorn/prefer-string-slice': 'error',
            'unicorn/prefer-dom-node-text-content': 'error',
            'unicorn/prefer-string-trim-start-end': 'warn',
            'unicorn/prefer-type-error': 'error',
            'unicorn/throw-new-error': 'error',

            // === sonarjs ===

            // 'sonarjs/generator-without-yield': 'error',
            'sonarjs/no-all-duplicated-branches': 'warn',
            'sonarjs/no-element-overwrite': 'warn',
            'sonarjs/no-identical-conditions': 'warn',
            'sonarjs/no-identical-expressions': 'warn',
            'sonarjs/no-one-iteration-loop': 'warn',
            'sonarjs/no-use-of-empty-return-value': 'warn',
            'sonarjs/max-switch-cases': ['warn', 20],
            'sonarjs/no-collapsible-if': 'warn',
            'sonarjs/no-collection-size-mischeck': 'error',
            'sonarjs/no-duplicate-string': ['warn', 6],
            'sonarjs/no-identical-functions': 'warn',
            'sonarjs/no-inverted-boolean-check': 'error',
            'sonarjs/no-redundant-boolean': 'warn',
            'sonarjs/no-redundant-jump': 'warn',
            'sonarjs/no-same-line-conditional': 'error',
            'sonarjs/no-small-switch': 'warn',
            'sonarjs/no-unused-collection': 'error',
            'sonarjs/no-useless-catch': 'warn',
            'sonarjs/prefer-object-literal': 'warn',
            'sonarjs/prefer-single-boolean-return': 'warn',
            'sonarjs/prefer-while': 'warn',
        },
    }),
});
