const path = require('node:path');

const { PresetsNames, conditional } = require('../../lib');

function createImportAliasSettings({ options = {}, context }) {
    const { alias: { root = context.root, paths = {} } = {} } = options;

    const useTsconfig = context.presets.has(PresetsNames.typescript);

    const alias = Object.entries(paths).reduce((acc, [key, value]) => {
        acc[key] = path.join(root, value);

        return acc;
    }, {});

    return {
        'import/resolver': {
            'eslint-import-resolver-custom-alias': {
                alias,
                extensions: context.imports.extensions,
            },
            ...conditional(useTsconfig, {
                typescript: {
                    alwaysTryTypes: true,
                    project: context.typescript.tsconfig,
                },
            }),
        },
    };
}

module.exports = {
    createImportAliasSettings,
};
