const { Extensions } = require('../../lib');

function createImportExtensionsRule(extensions) {
    return [
        'warn',
        'ignorePackages',
        Object.fromEntries(
            extensions
                // remove misc extensions, since they are often required
                .filter(ext => !Extensions.MISC.includes(ext))
                .map(ext => [ext.slice(1), 'never']),
        ),
    ];
}

module.exports = {
    createImportExtensionsRule,
};
