const { createPreset, PresetsNames, Extensions } = require('../../lib');

const { createImportAliasSettings } = require('./alias');
const { createImportExtensionsRule } = require('./extensions');

module.exports = createPreset({
    name: PresetsNames.imports,
    context: ({ context }) => {
        context.imports.extensions.push(...Extensions.MISC, ...Extensions.JS);
    },
    config: ({ context, options }) => {
        const {
            enableSort = false,
            sort: { newline = false, groups = DEFAULT_IMPORT_GROUPS } = {},
        } = options;

        const finalGroups = newline ? groups : [groups.flat()];

        return {
            plugins: ['import', 'simple-import-sort'],
            settings: {
                'import/extensions': context.imports.extensions,
                'import/core-modules': [],
                'import/ignore': ['\\.(coffee|scss|css|less|hbs|svg|json)$'],
                'import/internal-regex': '^@types/',
                ...createImportAliasSettings({ options, context }),
            },
            rules: {
                'import/no-unresolved': ['error', { commonjs: true, caseSensitive: true }],
                'import/no-default-export': 'warn',
                'import/no-anonymous-default-export': 'error',
                'import/export': 'error',
                'import/no-mutable-exports': 'error',
                'import/no-amd': 'error',
                'import/first': 'error',
                'import/no-duplicates': 'error',
                'import/extensions': createImportExtensionsRule(context.imports.extensions),
                'import/newline-after-import': 'warn',
                'import/no-webpack-loader-syntax': 'error',
                'import/no-self-import': 'error',
                'import/no-cycle': ['error', { maxDepth: Number.POSITIVE_INFINITY }],
                'import/no-useless-path-segments': ['warn', { commonjs: true }],

                'simple-import-sort/imports': enableSort
                    ? ['warn', { groups: finalGroups }]
                    : 'off',
                'simple-import-sort/exports': 'warn',
            },
        };
    },
});

const DEFAULT_IMPORT_GROUPS = [
    // side effects
    ['^\\u0000'],

    // node.js libraries and scoped libraries
    ['^(child_process|crypto|events|fs|http|https|os|path)(/.*)?$', '^@?\\w'],

    // common aliases (@app, @root, @/, ~/) and anything not matched
    ['^@', '^~', '^'],

    // relative imports
    ['^\\.'],
];
