const { createPreset, PresetsNames, conditional } = require('../lib');

module.exports = createPreset({
    name: PresetsNames.nextJs,
    config: ({ context }) => ({
        extends: ['plugin:@next/next/recommended'],
        rules: {
            'react/jsx-uses-react': 'off',
            'react/react-in-jsx-scope': 'off',
            'jsx-a11y/anchor-is-valid': [
                'error',
                {
                    components: ['Link'],
                    specialLink: ['hrefLeft', 'hrefRight'],
                    aspects: ['invalidHref', 'preferButton'],
                },
            ],

            ...conditional(context.presets.has(PresetsNames.imports), {
                'import/no-default-export': 'off',
            }),
        },
    }),
});
