const path = require('node:path');

const { createPreset, PresetsNames, Extensions, conditional } = require('../../lib');

const { createImportExtensionsRule } = require('../import/extensions');
const { createTypescriptRules } = require('./create-typescript-rules');

module.exports = createPreset({
    name: PresetsNames.typescript,
    context: ({ context, options }) => {
        context.imports.extensions.push(...Extensions.TS);
        context.typescript.root = path.resolve(context.root, options?.root ?? './');
        context.typescript.tsconfig = options?.tsconfig ?? 'tsconfig.json';
    },
    config: ({ context, options }) => ({
        plugins: ['@typescript-eslint'],
        parser: '@typescript-eslint/parser',
        parserOptions: {
            project: context.typescript.tsconfig,
            createDefaultProgram: true,
            tsconfigRootDir: context.typescript.root,
        },
        settings: conditional(context.presets.has(PresetsNames.imports), {
            'import/extensions': context.imports.extensions,
            'import/resolver': {
                node: {
                    extensions: context.imports.extensions,
                },
            },
            'import/ignore': ['\\.(coffee|scss|css|less|hbs|svg|json)$'],
            'import/external-module-folders': ['node_modules', 'node_modules/@types'],
            'import/parsers': {
                '@typescript-eslint/parser': Extensions.TS,
            },
        }),
        rules: conditional(context.presets.has(PresetsNames.imports), {
            'import/extensions': createImportExtensionsRule(context.imports.extensions),
        }),
        overrides: [
            {
                files: ['*.ts', '*.tsx'],
                rules: createTypescriptRules(context, options),
            },
        ],
    }),
});
