/* eslint-disable @typescript-eslint/naming-convention */

import { LoggerChunk, LoggerFields, LoggerLevel } from '../types';

import { printf } from './printf';
import { ParseArgumentsResult } from './parse-arguments';

export function createChunk({
    level,
    parsed: { fields: messageFields, message, err },
    fields: commonFields,
}: CreateChunkParams): LoggerChunk {
    const [msgFormat, ...msgArgs] = message;

    return {
        ...commonFields,
        ...messageFields,
        err,
        msg: msgArgs.length > 0 ? printf(msgFormat, msgArgs) : msgFormat,
        date: new Date(),
        level,
        msgArgs,
        msgFormat,
    };
}

export interface CreateChunkParams {
    level: LoggerLevel;
    parsed: ParseArgumentsResult;
    fields: LoggerFields;
}
