/* eslint-disable @typescript-eslint/naming-convention */

/**
 * Обрабатываем переданные пользователем аргументы, чтобы вытащить нужную информацию - ошибку, доп. поля и само сообщение
 *
 * Сообщения
 * @example parseArguments('hello') -> { message: ['hello'] }
 * @example parseArguments('hello %s', 'world') -> { message: ['hello %s', 'world'] }
 *
 * Дополнительные поля
 * @example parseArguments({ id: 2 }) -> { fields: { id: 2 }, message: [] }
 * @example parseArguments({ id: 2 }, 'hello') -> { fields: { id: 2 }, message: ['hello'] }
 * @example parseArguments({ id: 2 }, 'hello %s', 'world') -> { fields: { id: 2 }, message: ['hello %s', 'world'] }
 *
 * Ошибка
 * @example parseArguments(myError) -> { err: myError, message: ['my error'] }
 * @example parseArguments({ err: myError }) -> { err: myError, message: ['my error'] }
 * @example parseArguments({ err: myError, id: 2 }) -> { err: myError, fields: { id: 2 }, message: ['my error'] }
 * @example parseArguments({ err: myError, id: 2 }, 'hello') -> { err: myError, fields: { id: 2 }, message: ['hello'] }
 */
export function parseArguments(args: any[]): ParseArgumentsResult {
    const [first, ...otherArgs] = args;
    const firstIsError = first instanceof Error;
    const firstIsObject = typeof first === 'object';

    if (firstIsError) {
        return {
            err: first,
            message: otherArgs.length > 0 ? otherArgs : [first.message],
        };
    }

    if (firstIsObject) {
        if (first.err instanceof Error) {
            const { err, ...fields } = first;

            return {
                err,
                fields,
                message: otherArgs.length > 0 ? otherArgs : [err.message],
            };
        }

        return {
            fields: first,
            message: otherArgs,
        };
    }

    return {
        message: args,
    };
}

export interface ParseArgumentsResult {
    err?: Error;
    fields?: Record<string, any>;
    message: any[];
}
