/**
 * @see https://github.com/floatdrop/pff
 */
export function printf(input: string, replaces: (string | number)[]) {
    let res = '';

    const parts = input.split('%');
    const length = parts.length;

    if (length > 0) {
        res += parts[0];
    }

    for (let i = 1, argumentIndex = 0; i < length; i++) {
        if (parts[i][0] === 's' || parts[i][0] === 'd') {
            const value = replaces[argumentIndex++];

            res += parts[i][0] === 'd' ? Math.floor(Number(value)) : value;
        } else if (parts[i][0]) {
            res += '%' + parts[i][0];
        } else {
            i++;
            res += '%' + parts[i][0];
        }

        res += parts[i].substring(1);
    }

    return res;
}
