export const serializeJSON = (value: any) => JSON.stringify(value, createJSONReplacer());

export function createJSONReplacer() {
    const stack: any[] = [];
    const keys: string[] = [];

    const getCircularKey = (index: number) => cycleRef(index > 0 ? keys.slice(0, index) : []);

    return function replacer(this: any, key: string, value: any) {
        if (stack.length === 0) {
            stack.push(value);

            return value;
        }

        const thisIndex = stack.indexOf(this);
        const thisInStack = thisIndex >= 0;

        if (thisInStack) {
            stack.splice(thisIndex + 1);
            keys.splice(thisIndex, Infinity, key);
        } else {
            stack.push(this);
            keys.push(key);
        }

        if (stack.includes(value)) {
            return getCircularKey(stack.indexOf(value));
        }

        return value;
    };
}

export const cycleRef = (tokens: string[] = []) =>
    `<ref ${tokens.length > 0 ? tokens.join('.') : '~'}>`;
