import dayjs from 'dayjs';

import { LoggerChunk, LoggerLevel, LoggerStream } from '../types';

import { serializeJSON } from '../lib/serialize-json';
import { obfuscateByLimit } from '../lib/obfuscate';

export class NodeDevStream implements LoggerStream {
    write({ msg, date, level, err, name, msgArgs, msgFormat, ...fields }: LoggerChunk) {
        const main = `${dayjs(date).format('HH:mm:SSS')} - ${LoggerLevel[
            level
        ].toUpperCase()} - ${msg}`;
        const serialized = serializeJSON(fields);
        const content = [LoggerLevel.debug, LoggerLevel.fatal, LoggerLevel.trace].includes(level)
            ? serialized
            : obfuscateByLimit(serializeJSON(fields), 100);

        if (err) {
            console.debug(main);
            console.error(err, content);
        } else {
            console.log(main, '\n', content);
        }
    }
}
