import { LoggerChunk, LoggerLevel, LoggerStream } from '../types';

import { serializeJSON } from '../lib/serialize-json';

export class YandexDeployStream implements LoggerStream {
    write({ msg, level, name, requestId, ...fields }: LoggerChunk) {
        console.log(
            serializeJSON({
                msg,
                stackTrace: fields.err?.stack,
                level: LoggerLevel[level],
                levelStr: LoggerLevel[level],
                loggerName: name || 'unknown-logger',
                request_id: requestId,
                '@fields': fields,
            }),
        );
    }
}
