/* eslint-disable @typescript-eslint/naming-convention */

export interface LoggerOptions extends LoggerFields {
    /**
     * @deprecated Просто передавайте доп. свойства в самом объекте
     */
    fields?: LoggerFields;
    streams?: LoggerTarget[];
    middlewares?: LoggerMiddleware[];
}

export interface LoggerFields extends Record<string, any> {
    name?: string;
    // Стандартные доп. поля для серверных логов
    pid?: string | number;
    hostname?: string;
}

export interface LoggerChunk extends LoggerFields {
    date: Date;
    level: LoggerLevel;

    err?: Error;
    // Сформированное сообщение (.info('foo %s', 'bar') => 'foo bar')
    msg: string;
    // TODO А нужно ли?
    // Список доп. аргументов (.info('foo %s', 'bar') => ['bar'])
    msgArgs: any[];
    // Оригинальное сообщение (.info('foo %s', 'bar') => 'foo %s')
    msgFormat: string;
}

export interface LoggerMiddleware {
    (chunk: LoggerChunk): LoggerChunk;
}

export interface LoggerTarget {
    readonly level: LoggerLevel;
    readonly stream: LoggerStream;
}

export type LoggerStream = WritableLike<LoggerChunk>;

export interface WritableLike<T> {
    write(chunk: T): any | Promise<any>;
}

export type LoggerLevelName = keyof typeof LoggerLevel;
export enum LoggerLevel {
    trace = 10,
    debug = 20,
    info = 30,
    warn = 40,
    error = 50,
    fatal = 60,
}
