/**
 * @type {import('openapi').UserConfiguration}
 */
module.exports = {
    outputRoot: 'generated',
    sourceRoot: 'schemas',
    include: ['api.github.com.json'],
    output: {
        endpointsTypes: 'types/endpoints.ts',
    },
    resolve: {
        endpointMethodName({ original: { operationId }, method, path }) {
            const [group, name] = operationId.split('/');
            const names = name.split('-');
            const dirtyMethodName = [names[0], group.split('-').join(''), ...names.slice(1)]
                .map(part => part[0].toUpperCase() + part.slice(1))
                .join('');

            return dirtyMethodName[0].toLowerCase() + dirtyMethodName.slice(1);
        },
    },
};
