/* eslint-disable */
/* tslint:disable */
/*
 * ---------------------------------------------------------------
 * ## THIS FILE WAS GENERATED VIA OPENAPI GENERATOR             ##
 * ##                                                           ##
 * ## Не подлежит изменению, содержимое в любой момент          ##
 * ## может быть автоматически заменено                         ##
 * ---------------------------------------------------------------
 */

//#region FilterDataList
interface FilterDataList {
    values?: Array<string>;
}
//#endregion FilterDataList

//#region HotelGeoFeature
interface HotelGeoFeature {
    /**
     * Человекочитаемое расстояние, "1,1 км" (может не быть)
     *
     **/
    distance_text?: string;
    icon?: HotelGeoFeatureIcon;
    /**
     * Строковое представление геофичи (например, "1км от центра" или "Рядом аэропорт")
     *
     **/
    name?: string;
}
//#endregion HotelGeoFeature

//#region HotelGeoFeatureIcon
enum HotelGeoFeatureIcon {
    GEO_FEATURE_ICON_UNKNOWN = 'GEO_FEATURE_ICON_UNKNOWN',
    GEO_FEATURE_ICON_MAIN_DISTANCE = 'GEO_FEATURE_ICON_MAIN_DISTANCE',
    GEO_FEATURE_ICON_TRANSPORT_DISTANCE = 'GEO_FEATURE_ICON_TRANSPORT_DISTANCE',
}
//#endregion HotelGeoFeatureIcon

//#region HotelGeoInfo
interface HotelGeoInfo {
    /**
     * Гео фичи. расстояния до центра/моря и до транспорта
     *
     **/
    geo_features?: Array<HotelGeoFeature>;
    /**
     * Приблизительное расстояние от пользователя до отеля (в виде текста с единицей измерения). Передаётся только при сортировке по расстоянию.
     **/
    user_distance_text?: string;
}
//#endregion HotelGeoInfo

//#region HotelRubric
/**
 * Рубрика отеля в Справочнике
 *
 **/
interface HotelRubric {
    /**
     * @format int64
     **/
    id?: string;
    name?: string;
}
//#endregion HotelRubric

//#region ImageSize
interface ImageSize {
    /**
     * @format int64
     **/
    height?: number;
    identifier?: string;
    /**
     * @format int64
     **/
    width?: number;
}
//#endregion ImageSize

//#region KeyphrasematchFragments
interface KeyphrasematchFragments {
    /**
     * Позиция начала слова
     *
     * @format int64
     **/
    position?: number;
    /**
     * Длина слова
     *
     * @format int64
     **/
    size?: number;
}
//#endregion KeyphrasematchFragments

//#region QueryDataPollingData
interface QueryDataPollingData {
    /**
     * Навигационный контекст для смены отображаемой страницы _в списке_
     *
     **/
    navigation_token?: string;
    /**
     * Новому поллингу присваивается новый номер poll_epoch
     *
     * @format int64
     **/
    poll_epoch?: number;
    /**
     * Номер итерации поллинга фронта (для отладки и аналитики
     *
     * @format int64
     **/
    poll_iteration?: number;
}
//#endregion QueryDataPollingData

//#region QuickFilterSortSortList
interface QuickFilterSortSortList {
    values?: Array<V1QuickSorter>;
}
//#endregion QuickFilterSortSortList

//#region ProtobufAny
interface ProtobufAny {
    type_url?: string;
    /**
     * @format byte
     **/
    value?: string;
}
//#endregion ProtobufAny

//#region RuntimeError
interface RuntimeError {
    /**
     * @format int32
     **/
    code?: number;
    details?: Array<ProtobufAny>;
    error?: string;
    message?: string;
}
//#endregion RuntimeError

//#region TypeDate
/**
 * Represents a whole or partial calendar date, e.g. a birthday. The time of day
 * and time zone are either specified elsewhere or are not significant. The date
 * is relative to the Proleptic Gregorian Calendar. This can represent:
 *
 * * A full date, with non-zero year, month and day values
 * * A month and day value, with a zero year, e.g. an anniversary
 * * A year on its own, with zero month and day values
 * * A year and month value, with a zero day, e.g. a credit card expiration date
 *
 * Related types are [google.type.TimeOfDay][google.type.TimeOfDay] and `google.protobuf.Timestamp`.
 **/
interface TypeDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month, or 0
     * if specifying a year by itself or a year and month where the day is not
     * significant.
     * @format int32
     **/
    day?: number;
    /**
     * Month of year. Must be from 1 to 12, or 0 if specifying a year without a
     * month and day.
     * @format int32
     **/
    month?: number;
    /**
     * Year of date. Must be from 1 to 9999, or 0 if specifying a date without
     * a year.
     * @format int32
     **/
    year?: number;
}
//#endregion TypeDate

//#region V1AggregatedOfferInfo
interface V1AggregatedOfferInfo {
    cancellation_info_aggregate?: V1CancellationInfoAggregate;
    max_price?: V1Price;
    min_price?: V1Price;
    pansion_aggregate?: V1PansionAggregate;
}
//#endregion V1AggregatedOfferInfo

//#region V1AnalyticsData
/**
 * Аналитические данные - TODO(adurnev) рассказать приложению что надо посылкать
 *
 **/
interface V1AnalyticsData {
    /**
     * к какой рекламной кампании относится ссылка
     *
     **/
    utm_campaign?: string;
    /**
     * помогает различать объявления (чтобы было различие между несколькими ссылками)
     *
     **/
    utm_content?: string;
    /**
     * определяет тип трафика (баннер, клик по ссылке)
     *
     **/
    utm_medium?: string;
    /**
     * указывает на источник трафика (допустим сайт, с которого пришёл траффик)
     *
     **/
    utm_source?: string;
    /**
     * ключевое слово, по которому показывалось рекламное объявление
     *
     **/
    utm_term?: string;
}
//#endregion V1AnalyticsData

//#region V1Author
/**
 * Информация про автора
 *
 **/
interface V1Author {
    /**
     * Сылка на аватарку, пример https://avatars.mds.yandex.net/get-yapic/63256/Xi0TEwPziollZ53IxoLSDWABk-1/islands-75
     *
     **/
    avatar_url?: string;
    /**
     * Уровень, пример Знаток города 23 уровня
     *
     **/
    level?: string;
    /**
     * Имя
     *
     **/
    name?: string;
    /**
     * Ссылка на профель, пример https://reviews.yandex.ru/user/vbx3k1xgmqfwckgfaqmymxma38
     *
     **/
    profile_url?: string;
}
//#endregion V1Author

//#region V1BoundingBox
interface V1BoundingBox {
    left_down?: V1Coordinates;
    up_right?: V1Coordinates;
}
//#endregion V1BoundingBox

//#region V1CancellationInfo
interface V1CancellationInfo {
    /**
     * не null
     *
     **/
    has_free_cancellation?: boolean;
    /**
     * Название для отображения
     *
     **/
    name?: string;
    /**
     * Правила отмены
     *
     **/
    refund_rules?: Array<V1RefundRule>;
    refund_type?: V1RefundType;
}
//#endregion V1CancellationInfo

//#region V1CancellationInfoAggregate
enum V1CancellationInfoAggregate {
    CANCELLATION_INFO_AGGREGATE_UNKNOWN = 'CANCELLATION_INFO_AGGREGATE_UNKNOWN',
    CANCELLATION_INFO_AGGREGATE_FULLY_REFUNDABLE_AVAILABLE = 'CANCELLATION_INFO_AGGREGATE_FULLY_REFUNDABLE_AVAILABLE',
    CANCELLATION_INFO_AGGREGATE_REFUNDABLE_WITH_PENALTY_AVAILABLE = 'CANCELLATION_INFO_AGGREGATE_REFUNDABLE_WITH_PENALTY_AVAILABLE',
    CANCELLATION_INFO_AGGREGATE_NON_REFUNDABLE_AVAILABLE = 'CANCELLATION_INFO_AGGREGATE_NON_REFUNDABLE_AVAILABLE',
}
//#endregion V1CancellationInfoAggregate

//#region V1Coordinates
interface V1Coordinates {
    /**
     * широта
     *
     * @format double
     **/
    latitude?: number;
    /**
     * долгота
     *
     * @format double
     **/
    longitude?: number;
}
//#endregion V1Coordinates

//#region V1CountersQueryData
interface V1CountersQueryData {
    /**
     * Количество взрослых гостей default = 2
     *
     * @format int64
     **/
    adults?: number;
    bbox?: V1BoundingBox;
    checkin_date?: TypeDate;
    checkout_date?: TypeDate;
    /**
     * Возраста детей
     *
     **/
    children_ages?: Array<number>;
    /**
     * Атомы фильтрации. Можно считать, что это ключи, с которыми ассоциированы ствойста отеля.
     * По этим ключам находим только те отели, которые нам необходимы
     *
     **/
    filter_atoms?: Array<string>;
    /**
     * Возвращается с каждой итерацией поллинга
     *
     **/
    search_page_polling_id?: string;
}
//#endregion V1CountersQueryData

//#region V1DetailedFilter
interface V1DetailedFilter {
    /**
     * Атомы фильтрации. Можно считать, что это ключи, с которыми ассоциированы ствойста отеля.
     * По этим ключам находим только те отели, которые нам необходимы
     * Каждому фильтру соответствует свои атомы.
     * При запросе с фильтрацией необходимо передавать все атомы, соответствующие фильтру
     *
     **/
    atoms?: Array<string>;
    effect?: V1Effect;
    /**
     * Если enabled == true, то можно на контрол нажимать.
     * Если enabled == false, то нажимать нельзя (будет пустая выдача).
     **/
    enabled?: boolean;
    /**
     * Подсказка (количество отелей)
     *
     **/
    hint?: string;
    /**
     * Уникальный идентификатор фильтра
     *
     **/
    id?: string;
    /**
     * Название.
     **/
    name?: string;
}
//#endregion V1DetailedFilter

//#region V1Effect
enum V1Effect {
    EFFECT_UNKNOWN = 'EFFECT_UNKNOWN',
    EFFECT_SPECIAL_COLOR = 'EFFECT_SPECIAL_COLOR',
    EFFECT_SPECIAL_LOGO = 'EFFECT_SPECIAL_LOGO',
}
//#endregion V1Effect

//#region V1Feature
interface V1Feature {
    icon?: V1FeatureIcon;
    name?: string;
}
//#endregion V1Feature

//#region V1FeatureIcon
enum V1FeatureIcon {
    FEATURE_ICON_UNKNOWN = 'FEATURE_ICON_UNKNOWN',
    FEATURE_ICON_WI_FI = 'FEATURE_ICON_WI_FI',
    FEATURE_ICON_CAR_PARK = 'FEATURE_ICON_CAR_PARK',
    FEATURE_ICON_AIR_CONDITIONING = 'FEATURE_ICON_AIR_CONDITIONING',
    FEATURE_ICON_PAYMENT_BY_CREDIT_CARD = 'FEATURE_ICON_PAYMENT_BY_CREDIT_CARD',
    FEATURE_ICON_POOL = 'FEATURE_ICON_POOL',
    FEATURE_ICON_GYM = 'FEATURE_ICON_GYM',
    FEATURE_ICON_BEACH_LINE = 'FEATURE_ICON_BEACH_LINE',
}
//#endregion V1FeatureIcon

//#region V1FeatureRatingInfo
interface V1FeatureRatingInfo {
    /**
     * * Человеко-читаемое название. Для отрисовки.
     **/
    name?: string;
    /**
     * * Процент позитивных оценок - число от 0 до 100
     *
     * @format int64
     **/
    positive_percent?: number;
}
//#endregion V1FeatureRatingInfo

//#region V1Filter
interface V1Filter {
    detailed_filter?: V1FilterInfo;
    /**
     * Тип фильтров (цена, группа и тд)
     *
     **/
    type?: string;
}
//#endregion V1Filter

//#region V1FilterBatch
interface V1FilterBatch {
    /**
     * Агрегирования информация по фильтру
     *
     **/
    detailed_filter?: Array<V1Filter>;
}
//#endregion V1FilterBatch

//#region V1FilterData
interface V1FilterData {
    atoms?: FilterDataList;
    price?: V1PriceInterval;
    sort?: V1QuickSorter;
}
//#endregion V1FilterData

//#region V1FilterInfo
interface V1FilterInfo {
    /**
     * Идентификатор фильтра (не null)
     *
     **/
    id?: string;
    /**
     * Детали фильтра
     *
     **/
    items?: Array<V1DetailedFilter>;
    /**
     * Имя фильтра
     *
     **/
    name?: string;
    /**
     * Тип
     *
     **/
    type?: string;
}
//#endregion V1FilterInfo

//#region V1FilterParams
interface V1FilterParams {
    atoms?: Array<string>;
    priceFrom?: V1Price;
    priceTo?: V1Price;
}
//#endregion V1FilterParams

//#region V1Filters
interface V1Filters {
    /**
     * Фильтры
     *
     **/
    detailed_filters?: Array<V1Filter>;
    /**
     * Аггрегированная информация по фильтрам
     *
     **/
    detailed_filters_batches?: Array<V1FilterBatch>;
}
//#endregion V1Filters

//#region V1GeoLocationStatus
/**
 * - GEO_LOCATION_STATUS_UNKNOWN: Ещё не запрашивали разрешение
 * - GEO_LOCATION_STATUS_AVAILABLE: Геолокация доступна, имеем координаты пользователя
 * - GEO_LOCATION_STATUS_FORBIDDEN: Пользователь явно запретил доступ к геолокации
 *
 **/
enum V1GeoLocationStatus {
    GEO_LOCATION_STATUS_UNKNOWN = 'GEO_LOCATION_STATUS_UNKNOWN',
    GEO_LOCATION_STATUS_AVAILABLE = 'GEO_LOCATION_STATUS_AVAILABLE',
    GEO_LOCATION_STATUS_FORBIDDEN = 'GEO_LOCATION_STATUS_FORBIDDEN',
}
//#endregion V1GeoLocationStatus

//#region V1GetHotelCountersReq
interface V1GetHotelCountersReq {
    analytics_data?: V1AnalyticsData;
    query_data?: V1CountersQueryData;
}
//#endregion V1GetHotelCountersReq

//#region V1GetHotelCountersRsp
interface V1GetHotelCountersRsp {
    detailed_filters?: V1Filters;
    /**
     * @format int32
     **/
    total_hotels_count?: number;
}
//#endregion V1GetHotelCountersRsp

//#region V1GetHotelImagesReq
interface V1GetHotelImagesReq {
    hotel_id?: V1HotelID;
    paging_params?: V1PagingParams;
    /**
     * Parent ReqId
     *
     **/
    parent_request_id?: string;
}
//#endregion V1GetHotelImagesReq

//#region V1GetHotelImagesRsp
interface V1GetHotelImagesRsp {
    images?: Array<V1Image>;
}
//#endregion V1GetHotelImagesRsp

//#region V1GetHotelInfoReq
interface V1GetHotelInfoReq {
    analytics_data?: V1AnalyticsData;
    params?: V1OfferSearchParams;
    query_data?: V1HotelSuggestData;
}
//#endregion V1GetHotelInfoReq

//#region V1GetHotelInfoRsp
interface V1GetHotelInfoRsp {
    hotel?: V1Hotel;
    /**
     * * Описание отеля, полное.
     * Пример: "Гранд-отель самый лучший в мире. Круассаны, чурчхела, пахлава. Заходи, плати, отдыхай, спи, кушай."
     *
     **/
    hotel_description?: string;
    offers_info?: V1OffersInfo;
    ratings_info?: V1RatingsInfo;
    reviews_info?: V1ReviewsRsp;
    search_params?: V1OfferSearchParams;
}
//#endregion V1GetHotelInfoRsp

//#region V1GetHotelOffersReq
interface V1GetHotelOffersReq {
    analytics_data?: V1AnalyticsData;
    hotel_id?: V1HotelID;
    params?: V1OfferSearchParams;
    /**
     * Parent ReqId
     *
     **/
    parent_request_id?: string;
    /**
     * id поиска со страницы поиска отелей
     *
     **/
    search_page_polling_id?: string;
}
//#endregion V1GetHotelOffersReq

//#region V1GetHotelOffersRsp
interface V1GetHotelOffersRsp {
    offers_info?: V1OffersInfo;
}
//#endregion V1GetHotelOffersRsp

//#region V1Hotel
interface V1Hotel {
    /**
     * Адрес отеля
     *
     **/
    address?: string;
    /**
     * Сведения об отеле (фишки отеля)
     * не используется фактически, но мапится в Андроид
     *
     **/
    badges?: Array<V1HotelBadge>;
    coordinates?: V1Coordinates;
    /**
     * Свойство не нужно
     *
     * @format int32
     **/
    displayed_location_geo_id?: number;
    feature_groups?: Array<V1HotelFeatureGroup>;
    /**
     * Фичи отеля из справочника, до 6 штук
     *
     **/
    features?: Array<V1Feature>;
    geo_info?: HotelGeoInfo;
    /**
     * ссылка на отель (для вебвью)
     *
     **/
    hotel_url?: string;
    /**
     * изображения отеля
     *
     **/
    images?: Array<V1Image>;
    /**
     * добавлен ли в избранные
     *
     **/
    is_favorite?: boolean;
    /**
     * Доступен кэшбэк Яндекс Плюс (не null)
     *
     **/
    is_plus_available?: boolean;
    /**
     * Н
     *
     **/
    is_top_hotel?: boolean;
    /**
     * Отель Яндекса (не null)
     *
     **/
    is_yandex_hotel?: boolean;
    /**
     * Название отеля
     *
     **/
    name?: string;
    offer_info?: V1OfferInfo;
    /**
     * идентификатор отеля
     *
     * @format int64
     **/
    permalink?: string;
    /**
     * Завершён ли поллинг в этом отеле
     *
     **/
    polling_finished?: boolean;
    /**
     * Рейтинг. От 1 до 5. Дробное число, 1 знак после запятой.
     * @format double
     **/
    rating?: number;
    rubric?: HotelRubric;
    /**
     * Количество звезд. От 1 до 5
     *
     * @format int64
     **/
    stars?: number;
    /**
     * Количество фотографий
     *
     * @format int64
     **/
    total_image_count?: number;
    /**
     * количнство отзывов
     *
     * @format int32
     **/
    total_text_review_count?: number;
}
//#endregion V1Hotel

//#region V1HotelBadge
interface V1HotelBadge {
    /**
     * id бэйджа, для того чтобы рисовать разными стилями.
     **/
    id?: string;
    /**
     * Текст бэджа
     *
     **/
    text?: string;
    type?: V1HotelBadgeType;
}
//#endregion V1HotelBadge

//#region V1HotelBadgeType
enum V1HotelBadgeType {
    HOTEL_BADGE_TYPE_UNKNOWN = 'HOTEL_BADGE_TYPE_UNKNOWN',
    HOTEL_BADGE_TYPE_YANDEX_PLUS = 'HOTEL_BADGE_TYPE_YANDEX_PLUS',
}
//#endregion V1HotelBadgeType

//#region V1HotelFeatureGroup
interface V1HotelFeatureGroup {
    /**
     * * Удобства группы
     *
     **/
    features?: Array<V1Feature>;
    /**
     * *
     * Человеко-читаемое название. Для отрисовки.
     * @example "Услуги и удобства"
     *
     **/
    name?: string;
}
//#endregion V1HotelFeatureGroup

//#region V1HotelID
interface V1HotelID {
    /**
     * Слаг
     *
     **/
    hotel_slug?: string;
    /**
     * Пермалинк
     *
     * @format uint64
     **/
    permalink?: string;
}
//#endregion V1HotelID

//#region V1HotelPartnerOffersInfo
interface V1HotelPartnerOffersInfo {
    cancellation_info_aggregate?: V1CancellationInfoAggregate;
    default_offer?: V1OfferInfo;
    default_offer_cancellation_info?: V1CancellationInfo;
    default_offer_pansion?: V1PansionInfo;
    /**
     * Идентификатор оператора
     *
     **/
    operator_id?: string;
    pansion_aggregate?: V1PansionAggregate;
}
//#endregion V1HotelPartnerOffersInfo

//#region V1HotelRoom
interface V1HotelRoom {
    /**
     * Группы удобств в номере
     *
     **/
    amenity_groups?: Array<V1RoomAmenityGroup>;
    area?: V1RoomArea;
    /**
     * Группы кроватей. Объединяются через "ИЛИ", т.е. единовременно в номере доступна только одна из групп.
     **/
    bed_groups?: Array<V1RoomBedGroup>;
    /**
     * * Описание номера
     *
     **/
    description?: string;
    /**
     * * Id комнаты.
     **/
    id?: string;
    /**
     * * Фотографии номера
     *
     **/
    images?: Array<V1Image>;
    /**
     * Главные удобства в номере (максимум 3)
     *
     **/
    main_amenities?: Array<V1RoomAmenity>;
    /**
     * *
     * Человеко-читаемое название. Для отрисовки.
     * @example "Стандартный номер"
     *
     **/
    name?: string;
}
//#endregion V1HotelRoom

//#region V1HotelSuggestData
/**
 * Данные про отель в подсказке.
 **/
interface V1HotelSuggestData {
    /**
     * Пермалинк отеля, aka идентификатор отеля в справочнике организаций.
     * @format uint64
     **/
    permalink?: string;
    /**
     * уникальный текстовый слаг отеля для url.
     **/
    slug?: string;
}
//#endregion V1HotelSuggestData

//#region V1HotelsOperator
interface V1HotelsOperator {
    /**
     * Иконка для отрисовки.
     **/
    icon_url?: string;
    /**
     * Id оператора.
     **/
    id?: string;
    /**
     * Наименование оператора.
     **/
    name?: string;
}
//#endregion V1HotelsOperator

//#region V1HotelsSuggestReq
interface V1HotelsSuggestReq {
    /**
     * Максимальное количество элементов в списке подсказок.
     * @format int64
     **/
    limit?: number;
    /**
     * Поисковый запрос, который пользователь начал печатать в поле поиска.
     **/
    query?: string;
    /**
     * Порядковый номер поискового запроса в рамках поискового flow. Нужен для логирования.
     * @format int64
     **/
    request_index?: number;
}
//#endregion V1HotelsSuggestReq

//#region V1HotelsSuggestRsp
interface V1HotelsSuggestRsp {
    groups?: Array<V1SuggestGroup>;
}
//#endregion V1HotelsSuggestRsp

//#region V1Image
interface V1Image {
    size_orig?: ImageSize;
    sizes?: Array<ImageSize>;
    url?: string;
    /**
     * Шаблон урла, подставь код размера
     *
     **/
    url_template?: string;
}
//#endregion V1Image

//#region V1ImageParams
interface V1ImageParams {
    /**
     * Количество картинок
     *
     * @format int32
     **/
    limit?: number;
    size?: V1ImageSize;
}
//#endregion V1ImageParams

//#region V1ImageReview
/**
 * Картинка для отзывов
 *
 **/
interface V1ImageReview {
    /**
     * Идентификатор, нужен для удаления
     *
     **/
    id?: string;
    image?: V1Image;
    moderation?: V1Moderation;
    /**
     * Теги
     *
     **/
    tags?: Array<string>;
}
//#endregion V1ImageReview

//#region V1ImageSize
/**
 * В отелях для получения изображений используется неймспейс Справочника (altay) Аватарницы
 * Стандартные размеры из таблицы в комментариях https://st.yandex-team.ru/MDS-3318#586266e720fe103ec4ee4d48
 *
 * - IMAGE_SIZE_UNKNOWN: зарезирвирова
 * - IMAGE_SIZE_ORIG: 6720*3780
 * - IMAGE_SIZE_XXXS: 50*50
 * - IMAGE_SIZE_XXS: 75*74
 * - IMAGE_SIZE_XS: 100*100
 * - IMAGE_SIZE_S: 150*150
 * - IMAGE_SIZE_M: 300*300
 * - IMAGE_SIZE_L: 500*500
 * - IMAGE_SIZE_XL: 800*800
 * - IMAGE_SIZE_XXL: 1024*1024
 * - IMAGE_SIZE_XXXL: 1280*1280
 **/
enum V1ImageSize {
    IMAGE_SIZE_UNKNOWN = 'IMAGE_SIZE_UNKNOWN',
    IMAGE_SIZE_ORIG = 'IMAGE_SIZE_ORIG',
    IMAGE_SIZE_XXXS = 'IMAGE_SIZE_XXXS',
    IMAGE_SIZE_XXS = 'IMAGE_SIZE_XXS',
    IMAGE_SIZE_XS = 'IMAGE_SIZE_XS',
    IMAGE_SIZE_S = 'IMAGE_SIZE_S',
    IMAGE_SIZE_M = 'IMAGE_SIZE_M',
    IMAGE_SIZE_L = 'IMAGE_SIZE_L',
    IMAGE_SIZE_XL = 'IMAGE_SIZE_XL',
    IMAGE_SIZE_XXL = 'IMAGE_SIZE_XXL',
    IMAGE_SIZE_XXXL = 'IMAGE_SIZE_XXXL',
}
//#endregion V1ImageSize

//#region V1Keyphrase
/**
 * Ключевое слово
 *
 **/
interface V1Keyphrase {
    /**
     * ключевое слово
     *
     **/
    name?: string;
    /**
     * количество отзывов с таким словом
     *
     * @format int64
     **/
    review_count?: number;
}
//#endregion V1Keyphrase

//#region V1Keyphrasematch
/**
 * Сегменты нахождения ключевого слова в тексте, используется на портале для выделения цветом ключевых слов
 *
 **/
interface V1Keyphrasematch {
    /**
     * Сегменты
     *
     **/
    fragments?: Array<KeyphrasematchFragments>;
}
//#endregion V1Keyphrasematch

//#region V1LogHotelsSuggestSelectedReq
interface V1LogHotelsSuggestSelectedReq {
    /**
     * Порядковый номер поискового запроса в рамках поискового flow, после которого пользователь совершил выбор.
     * @format int64
     **/
    request_index?: number;
    /**
     * Идентификатор подсказки, выбранной пользователем.
     **/
    selected_id?: string;
}
//#endregion V1LogHotelsSuggestSelectedReq

//#region V1LogHotelsSuggestSelectedRsp
type V1LogHotelsSuggestSelectedRsp = {};
//#endregion V1LogHotelsSuggestSelectedRsp

//#region V1Moderation
/**
 * Модерация
 *
 **/
interface V1Moderation {
    status?: V1ModerationStatus;
}
//#endregion V1Moderation

//#region V1ModerationStatus
/**
 * Статусы модерации
 *
 * - MODERATION_STATUS_IN_PROGRESS: В обработке
 * - MODERATION_STATUS_ACCEPTED: Принят
 * - MODERATION_STATUS_DECLINED: Отклонен
 **/
enum V1ModerationStatus {
    MODERATION_STATUS_UNKNOWN = 'MODERATION_STATUS_UNKNOWN',
    MODERATION_STATUS_IN_PROGRESS = 'MODERATION_STATUS_IN_PROGRESS',
    MODERATION_STATUS_ACCEPTED = 'MODERATION_STATUS_ACCEPTED',
    MODERATION_STATUS_DECLINED = 'MODERATION_STATUS_DECLINED',
}
//#endregion V1ModerationStatus

//#region V1NavigationTokens
interface V1NavigationTokens {
    /**
     * Токен, который необходимо передать бекенду для перехода на следующую страницу.
     **/
    next_page?: string;
}
//#endregion V1NavigationTokens

//#region V1OfferInfo
interface V1OfferInfo {
    /**
     * Бэджики для данного оффера
     *
     **/
    badges?: Array<V1HotelBadge>;
    cancellation_info?: V1CancellationInfo;
    /**
     * *
     * Ссылка на бронирование, куда переходить при клике на данный оффер.
     * @example "https://booking.com/..."
     * для boy формируем урл на вебный чекаут
     *
     **/
    landing_url?: string;
    /**
     * *
     * Наименование предложения
     * @example "Стандартный номер с 1 кроватью или 2 креслами"
     *
     **/
    name?: string;
    /**
     * Идентификатор оператора
     *
     **/
    operator_id?: string;
    pansion_info?: V1PansionInfo;
    /**
     * цена в рублях
     *
     * @format uint64
     **/
    price?: string;
    /**
     * Идентификатор комнаты
     *
     **/
    room_id?: string;
    /**
     * зачеркнутая цена (если есть скидка по предложению)
     *
     * @format uint64
     **/
    strike_through_price?: string;
    /**
     * Флаг предложения от Яндекса
     *
     **/
    yandex_offer?: boolean;
    yandex_plus_info?: V1YandexPlusInfo;
}
//#endregion V1OfferInfo

//#region V1OfferSearchParams
/**
 * Параметры поиска отельных предложений. Дополняют данные о регионе или конкретном отеле для поиска.
 * Для валидного поискового запроса все поля кроме возрастов детей должны быть заполнены.
 **/
interface V1OfferSearchParams {
    /**
     * Количество взрослых гостей.
     * @format int64
     **/
    adults?: number;
    checkin_date?: TypeDate;
    checkout_date?: TypeDate;
    /**
     * Возраста детей.
     **/
    children_ages?: Array<number>;
}
//#endregion V1OfferSearchParams

//#region V1OfferSearchProgress
interface V1OfferSearchProgress {
    finished?: boolean;
    finished_partners?: Array<V1PartnerId>;
    /**
     * @format int64
     **/
    partners_complete?: number;
    /**
     * @format int64
     **/
    partners_total?: number;
    pending_partners?: Array<V1PartnerId>;
}
//#endregion V1OfferSearchProgress

//#region V1OffersInfo
interface V1OffersInfo {
    aggregated_offer_info?: V1AggregatedOfferInfo;
    /**
     * *
     * Предложения, показывающиеся в основном списке, над блоком предложений партнёров.
     *
     * Если активен и успешен матчинг партнёрских офферов в команты - в это поле попадают все оффера.
     * Если матчинг не активен, то тут только BoY предложения.
     * Только оффера из этого списка участвуют в группировке по комнатам (если есть поле rooms).
     *
     * Может отсутствовать, тогда:
     * 1. В случае rooms==null не рисуем блок яндексовых цен (комнаты или плоский список).
     * 2. В случае rooms!=null во всех комнатах просто не будет предложений, но сами комнаты рисуем.
     **/
    main_offers?: Array<V1OfferInfo>;
    /**
     * рекомендуемая пауза перед следующей итерацией поллинга
     *
     * @format int32
     **/
    next_polling_request_delay_ms?: number;
    /**
     * *
     * Общее число предложений о размещении в данном отеле.
     * Используется для подписей вида "Еще N предложений от M партнеров."
     *
     * @format int32
     **/
    offerCount?: number;
    offer_search_progress?: V1OfferSearchProgress;
    /**
     * * Словарь Информации об операторах.
     **/
    operators?: {
        [key: string]: V1HotelsOperator | undefined;
    };
    /**
     * *
     * Общее число партнеров, предоставляющих информацию о размещении в данном отеле.
     * Используется для подписей вида "Еще N предложений от M партнеров."
     * Для мета-варианта и для BoY-варианта всегда показывает общее число партнеров по количеству провязок отеля.
     * Может не совпадать с количеством опрашиваемых при поиске партнеров.
     * @format int32
     **/
    operators_count?: number;
    /**
     * *
     * Предложения не-BoY партнёров. Рисуются в конце списка, не участвуют в группировке по комнатам.
     * Может отсутствовать, тогда не рисуем блок партнёрских цен.
     * Если активен и успешен матчинг партнёрских предложений, то это поле пусто.
     **/
    partner_offers?: Array<V1HotelPartnerOffersInfo>;
    /**
     * Завершили ли поиск
     *
     **/
    polling_finished?: boolean;
    /**
     * *
     * Список комнат. Порядок комнат на странице задаётся порядком в этом списке.
     * Офферы внутри комнат должны быть взяты из списка mainOffers и иметь тот же относительный порядок, что в списке mainOffers.
     *
     * Может отсутствовать, тогда рисуем вариант страницы без комнат.
     **/
    rooms?: Array<V1HotelRoom>;
}
//#endregion V1OffersInfo

//#region V1PagingParams
/**
 * Пагинация, постраницный запрос
 *
 **/
interface V1PagingParams {
    /**
     * Сколько взять, дефолт 4 (для первой странице)
     *
     * @format int64
     **/
    limit?: number;
    /**
     * Сколько пропустить, дефолт 0
     *
     * @format int64
     **/
    offset?: number;
}
//#endregion V1PagingParams

//#region V1PansionAggregate
enum V1PansionAggregate {
    PANSION_AGGREGATE_UNKNOWN = 'PANSION_AGGREGATE_UNKNOWN',
    PANSION_AGGREGATE_NO_PANSION_AVAILABLE = 'PANSION_AGGREGATE_NO_PANSION_AVAILABLE',
    PANSION_AGGREGATE_PANSION_AVAILABLE = 'PANSION_AGGREGATE_PANSION_AVAILABLE',
}
//#endregion V1PansionAggregate

//#region V1PansionInfo
interface V1PansionInfo {
    pansion_name?: string;
    pansion_type?: V1PansionType;
}
//#endregion V1PansionInfo

//#region V1PansionType
/**
 * - PANSION_TYPE_UNKNOWN: Неизвестный тип
 * - PANSION_TYPE_ALL_INCLUSIVE: All inclusive
 * - PANSION_TYPE_BED_AND_BREAKFAST: Bed and breakfast (Завтрак)
 * - PANSION_TYPE_FULL_BOARD: Full board (Завтрак, обед, ужин; пансион)
 * - PANSION_TYPE_HALF_BOARD: Half board (Завтрак и ужин; полупансион)
 * - PANSION_TYPE_ROOM_ONLY: Room only
 * - PANSION_TYPE_ULTRA_ALL_INCLUSIVE: Ultra All Inclusive
 * - PANSION_TYPE_LIGHT_ALL_INCLUSIVE: Light All Inclusive
 * - PANSION_TYPE_DINNER_ONLY: Dinner Only (только ужин)
 *
 **/
enum V1PansionType {
    PANSION_TYPE_UNKNOWN = 'PANSION_TYPE_UNKNOWN',
    PANSION_TYPE_ALL_INCLUSIVE = 'PANSION_TYPE_ALL_INCLUSIVE',
    PANSION_TYPE_BED_AND_BREAKFAST = 'PANSION_TYPE_BED_AND_BREAKFAST',
    PANSION_TYPE_FULL_BOARD = 'PANSION_TYPE_FULL_BOARD',
    PANSION_TYPE_HALF_BOARD = 'PANSION_TYPE_HALF_BOARD',
    PANSION_TYPE_ROOM_ONLY = 'PANSION_TYPE_ROOM_ONLY',
    PANSION_TYPE_ULTRA_ALL_INCLUSIVE = 'PANSION_TYPE_ULTRA_ALL_INCLUSIVE',
    PANSION_TYPE_LIGHT_ALL_INCLUSIVE = 'PANSION_TYPE_LIGHT_ALL_INCLUSIVE',
    PANSION_TYPE_DINNER_ONLY = 'PANSION_TYPE_DINNER_ONLY',
}
//#endregion V1PansionType

//#region V1PartnerId
/**
 * - PARTNER_ID_BOOKING: см https://a.yandex-team.ru/arc/trunk/arcadia/travel/tours/tours-model/src/main/scala/ru/yandex/tours/model/hotels/Partners.scala?rev=3630474#L12
 * Важно, чтобы константы совпадали с указанными, иначе аналитика по старым и новым label-ам сильно не сойдется
 * - PARTNER_ID_DOLPHIN: PARTNER_ID_HOTELBOOK      = 42; // enum reserved is not available in protobuf 3.4.1
 *
 **/
enum V1PartnerId {
    PARTNER_ID_UNUSED = 'PARTNER_ID_UNUSED',
    PARTNER_ID_BOOKING = 'PARTNER_ID_BOOKING',
    PARTNER_ID_HOTELS101 = 'PARTNER_ID_HOTELS101',
    PARTNER_ID_TRAVELLINE = 'PARTNER_ID_TRAVELLINE',
    PARTNER_ID_HOTELSCOMBINED = 'PARTNER_ID_HOTELSCOMBINED',
    PARTNER_ID_OSTROVOK = 'PARTNER_ID_OSTROVOK',
    PARTNER_ID_EXPEDIA = 'PARTNER_ID_EXPEDIA',
    PARTNER_ID_DOLPHIN = 'PARTNER_ID_DOLPHIN',
    PARTNER_ID_BNOVO = 'PARTNER_ID_BNOVO',
    PARTNER_ID_TVIL = 'PARTNER_ID_TVIL',
    PARTNER_ID_BRONEVIK = 'PARTNER_ID_BRONEVIK',
}
//#endregion V1PartnerId

//#region V1Price
/**
 * Цена.
 **/
interface V1Price {
    /**
     * Трехбуквенный код валюты по ISO-4217. https://ru.wikipedia.org/wiki/ISO_4217
     *
     **/
    currency?: string;
    /**
     * Сумма в заданной валюте.
     * @format double
     **/
    value?: number;
}
//#endregion V1Price

//#region V1PriceFilter
interface V1PriceFilter {
    /**
     * RUB USD
     *
     **/
    currency?: string;
    /**
     * [x_0, x_1, x_2, ..., x_{N-1}], то есть N значений.
     * Bounds описывает набор границ ценовых корзин, где расчитана величина гистограммы.
     **/
    histogramBounds?: Array<number>;
    /**
     * [c_0, c_1, ..., c_{N-1}], то есть N значения.
     * Counts может отсутствовать -- тогда столбики рисовать не надо!
     *
     **/
    histogramCounts?: Array<number>;
    /**
     * @format int64
     **/
    maxPriceEstimate?: number;
    /**
     * @format int64
     **/
    minPriceEstimate?: number;
    /**
     * Название для подписи
     *
     **/
    name?: string;
}
//#endregion V1PriceFilter

//#region V1PriceInterval
interface V1PriceInterval {
    /**
     * Трехбуквенный код валюты по ISO-4217. https://ru.wikipedia.org/wiki/ISO_4217
     *
     **/
    currency?: string;
    /**
     * цена в рублях от
     *
     * @format int64
     **/
    from?: number;
    /**
     * цена в рублях до
     *
     * @format int64
     **/
    to?: number;
}
//#endregion V1PriceInterval

//#region V1QueryData
interface V1QueryData {
    /**
     * Количество взрослых гостей default = 2
     *
     * @format int64
     **/
    adults?: number;
    bbox?: V1BoundingBox;
    checkin_date?: TypeDate;
    checkout_date?: TypeDate;
    /**
     * Возраста детей
     *
     **/
    children_ages?: Array<number>;
    /**
     * Регион поиска, заданный пользователем (при первичном запросе)
     *
     * @format int32
     **/
    geo_id?: number;
    geo_location_status?: V1GeoLocationStatus;
    nearest_hotels_sort_origin?: V1Coordinates;
    /**
     * Сколько отелей отображать в списке (value = 10 нужно для корректного формирования навигационных токенов).
     * @format int32
     **/
    page_hotel_count?: number;
    polling_data?: QueryDataPollingData;
    /**
     * Контекст поиска
     *
     **/
    search_context?: string;
    search_reason?: V1StartSearchReason;
    /**
     * Сколько отелей нужно всего, дефолтное значение  должно быть 50
     *
     * @format int32
     **/
    total_hotel_limit?: number;
    user_coordinates?: V1Coordinates;
}
//#endregion V1QueryData

//#region V1QuickFilter
interface V1QuickFilter {
    atoms_off?: Array<string>;
    /**
     * Для определения факта нажатости быстрофильтра:
     * если в текущем стейте фильтра все атомы из atomsOn есть, и нет ни одного из atomsOff - то быстрофильтр нажат
     * При нажатии на быстрофильтр: все атомы из atomsOff - удаляем из стейта, Все атомы из atomsOn - добавляем в
     * стейт.
     * При отжатии быстрофильтра: Все атомы из atomsOn удаляем из стейта. atomsOff в стейте быть не могло, иначе
     * фильтр бы не был нажат
     *
     **/
    atoms_on?: Array<string>;
    effect?: V1Effect;
    /**
     * Если enabled == true, то можно на контрол нажимать.
     * Если enabled == false, то нажимать нельзя (будет пустая выдача).
     **/
    enabled?: boolean;
    /**
     * Подсказка
     *
     **/
    hint?: string;
    /**
     * Уникальный идентификатор фильтра (не null)
     *
     **/
    id?: string;
    /**
     * Название.
     **/
    name?: string;
}
//#endregion V1QuickFilter

//#region V1QuickFilterPrice
interface V1QuickFilterPrice {
    /**
     * Подробное название.
     **/
    name?: string;
    price?: V1PriceInterval;
    selected_price?: V1PriceInterval;
    /**
     * Короткое название.
     **/
    short_name?: string;
}
//#endregion V1QuickFilterPrice

//#region V1QuickFilterSort
interface V1QuickFilterSort {
    available?: QuickFilterSortSortList;
    selected?: V1QuickSorter;
}
//#endregion V1QuickFilterSort

//#region V1QuickFilters
interface V1QuickFilters {
    filter?: V1QuickFilter;
    price?: V1QuickFilterPrice;
    sort?: V1QuickFilterSort;
}
//#endregion V1QuickFilters

//#region V1QuickSorter
interface V1QuickSorter {
    /**
     * полное название сортировки "Сначала популярные"...
     **/
    name?: string;
    /**
     * название сортировки "Популярные"...
     **/
    short_name?: string;
    sorter?: V1Sort;
}
//#endregion V1QuickSorter

//#region V1RatingsInfo
interface V1RatingsInfo {
    /**
     * * Список оценок отеля из правой колонки макета.
     **/
    feature_ratings?: Array<V1FeatureRatingInfo>;
    /**
     * * Отзыв-тизер. На макете -- сверху справа, "80% гостям что-то понравилось."
     *
     **/
    teaser?: string;
}
//#endregion V1RatingsInfo

//#region V1RefundRule
interface V1RefundRule {
    /**
     * Не включительная граница. Может быть пусто, это означает, что правило не имеет правой границы (заканчивает действовать в +inf)
     *
     **/
    ends_at?: string;
    /**
     * это поле заполняется только когда Type = RT_REFUNDABLE_WITH_PENALTY
     *
     * @format int64
     **/
    penalty?: number;
    /**
     * Включительная граница. Может быть пусто, это означает, что правило не имеет левой границы (начинает действовать в -inf)
     *
     **/
    starts_at?: string;
    type?: V1RefundType;
}
//#endregion V1RefundRule

//#region V1RefundType
enum V1RefundType {
    REFUND_TYPE_UNKNOWN = 'REFUND_TYPE_UNKNOWN',
    REFUND_TYPE_FULLY_REFUNDABLE = 'REFUND_TYPE_FULLY_REFUNDABLE',
    REFUND_TYPE_REFUNDABLE_WITH_PENALTY = 'REFUND_TYPE_REFUNDABLE_WITH_PENALTY',
    REFUND_TYPE_NON_REFUNDABLE = 'REFUND_TYPE_NON_REFUNDABLE',
}
//#endregion V1RefundType

//#region V1RegionSuggestData
/**
 * Данные про регион в подсказке.
 **/
interface V1RegionSuggestData {
    /**
     * @format int64
     **/
    geoId?: string;
}
//#endregion V1RegionSuggestData

//#region V1ReviewQuickFilterPhrase
interface V1ReviewQuickFilterPhrase {
    /**
     * Доступные варианты ключевых слов
     *
     **/
    available?: Array<V1Keyphrase>;
    /**
     * Выбранное ключевое слово
     *
     **/
    selected?: string;
    /**
     * Общее количество
     *
     * @format int64
     **/
    total_count?: number;
}
//#endregion V1ReviewQuickFilterPhrase

//#region V1ReviewQuickFilterSort
interface V1ReviewQuickFilterSort {
    /**
     * Доступные сортировки
     *
     **/
    available?: Array<V1ReviewQuickSorter>;
    selected?: V1ReviewSort;
}
//#endregion V1ReviewQuickFilterSort

//#region V1ReviewQuickSorter
interface V1ReviewQuickSorter {
    id?: V1ReviewSort;
    /**
     * название сортировки "Популярные"...
     **/
    short_title?: string;
    /**
     * полное название сортировки "Сначала популярные"...
     **/
    title?: string;
}
//#endregion V1ReviewQuickSorter

//#region V1ReviewReactionType
/**
 * - REVIEW_REACTION_NONE: Снимает выбранное значение (ничего не выбрано)
 * - REVIEW_REACTION_LIKE: Лайк
 * - REVIEW_REACTION_DISLIKE: Дизлайк
 *
 **/
enum V1ReviewReactionType {
    REVIEW_REACTION_UNKNOWN = 'REVIEW_REACTION_UNKNOWN',
    REVIEW_REACTION_NONE = 'REVIEW_REACTION_NONE',
    REVIEW_REACTION_LIKE = 'REVIEW_REACTION_LIKE',
    REVIEW_REACTION_DISLIKE = 'REVIEW_REACTION_DISLIKE',
}
//#endregion V1ReviewReactionType

//#region V1ReviewRsp
/**
 * Reviews
 * TODO(adurnev) убрать лишнее
 * Отзыв
 *
 **/
interface V1ReviewRsp {
    author?: V1Author;
    /**
     * Ответ владельца
     *
     **/
    business_comment?: string;
    /**
     * Количество комментариев
     *
     * @format int64
     **/
    comment_count?: number;
    /**
     * Идентификатор
     *
     **/
    id?: string;
    /**
     * Картинки
     *
     **/
    images?: Array<V1ImageReview>;
    moderation?: V1Moderation;
    phrase_match?: V1Keyphrasematch;
    /**
     * Рейтинг
     *
     * @format int64
     **/
    rating?: number;
    /**
     * Сокращенный по длине отзыв
     *
     **/
    snippet?: string;
    /**
     * Отзыв
     *
     **/
    text?: string;
    /**
     * Количество дизлайков
     *
     * @format int64
     **/
    total_dislike_count?: number;
    /**
     * Количество лайков
     *
     * @format int64
     **/
    total_like_count?: number;
    /**
     * Дата обновления
     *
     **/
    updated_at?: string;
    user_reaction?: V1ReviewReactionType;
}
//#endregion V1ReviewRsp

//#region V1ReviewSort
enum V1ReviewSort {
    REVIEW_SORT_UNKNOWN = 'REVIEW_SORT_UNKNOWN',
    REVIEW_SORT_RELEVANT_FIRST = 'REVIEW_SORT_RELEVANT_FIRST',
    REVIEW_SORT_TIME_DESC = 'REVIEW_SORT_TIME_DESC',
    REVIEW_SORT_RATING_ASC = 'REVIEW_SORT_RATING_ASC',
    REVIEW_SORT_RATING_DESC = 'REVIEW_SORT_RATING_DESC',
    REVIEW_SORT_LIKES_COUNT_DESC = 'REVIEW_SORT_LIKES_COUNT_DESC',
}
//#endregion V1ReviewSort

//#region V1ReviewsRsp
interface V1ReviewsRsp {
    /**
     * Есть ли еще что запрашивать
     *
     **/
    has_more?: boolean;
    phrases?: V1ReviewQuickFilterPhrase;
    /**
     * Отзывы
     *
     **/
    reviews?: Array<V1ReviewRsp>;
    sort?: V1ReviewQuickFilterSort;
    /**
     * Количество отзывов
     *
     * @format int64
     **/
    total_review_count?: number;
    user_review?: V1ReviewRsp;
}
//#endregion V1ReviewsRsp

//#region V1RoomAmenity
interface V1RoomAmenity {
    bed_item?: V1RoomBedItem;
    icon?: V1RoomAmenityIcon;
    /**
     * *
     * Человеко-читаемое название. Для отрисовки.
     * Пример: "35 кв.м.", "Холодильник", "Мини-бар: за доплату".
     **/
    name?: string;
}
//#endregion V1RoomAmenity

//#region V1RoomAmenityGroup
interface V1RoomAmenityGroup {
    /**
     * Удобства группы
     *
     **/
    amenities?: Array<V1RoomAmenity>;
    /**
     * *
     * Человеко-читаемое название. Для отрисовки заголовка группы удобств.
     * @example "Ванная комната"
     *
     **/
    name?: string;
}
//#endregion V1RoomAmenityGroup

//#region V1RoomAmenityIcon
enum V1RoomAmenityIcon {
    ROOM_AMENITY_UNKNOWN = 'ROOM_AMENITY_UNKNOWN',
    ROOM_AMENITY_WIFI = 'ROOM_AMENITY_WIFI',
    ROOM_AMENITY_AIR_CONDITIONING = 'ROOM_AMENITY_AIR_CONDITIONING',
    ROOM_AMENITY_FLAT_PANEL_TV = 'ROOM_AMENITY_FLAT_PANEL_TV',
    ROOM_AMENITY_BATHROOM = 'ROOM_AMENITY_BATHROOM',
    ROOM_AMENITY_TELEVISION = 'ROOM_AMENITY_TELEVISION',
    ROOM_AMENITY_CITY_VIEW = 'ROOM_AMENITY_CITY_VIEW',
    ROOM_AMENITY_MINIBAR = 'ROOM_AMENITY_MINIBAR',
    ROOM_AMENITY_COURT_VIEW = 'ROOM_AMENITY_COURT_VIEW',
    ROOM_AMENITY_BATHTUB = 'ROOM_AMENITY_BATHTUB',
    ROOM_AMENITY_BALCONY = 'ROOM_AMENITY_BALCONY',
    ROOM_AMENITY_COFFEE_MACHINE = 'ROOM_AMENITY_COFFEE_MACHINE',
    ROOM_AMENITY_SOUNDPROOFED_ROOMS = 'ROOM_AMENITY_SOUNDPROOFED_ROOMS',
    ROOM_AMENITY_BALCONY_WITH_VIEW = 'ROOM_AMENITY_BALCONY_WITH_VIEW',
    ROOM_AMENITY_SEA_VIEW = 'ROOM_AMENITY_SEA_VIEW',
    ROOM_AMENITY_MOUNTAIN_VIEW = 'ROOM_AMENITY_MOUNTAIN_VIEW',
    ROOM_AMENITY_RIVER_VIEW = 'ROOM_AMENITY_RIVER_VIEW',
    ROOM_AMENITY_PARK_VIEW = 'ROOM_AMENITY_PARK_VIEW',
    ROOM_AMENITY_GARDEN_VIEW = 'ROOM_AMENITY_GARDEN_VIEW',
    ROOM_AMENITY_POOL_VIEW = 'ROOM_AMENITY_POOL_VIEW',
    ROOM_AMENITY_FOREST_VIEW = 'ROOM_AMENITY_FOREST_VIEW',
    ROOM_AMENITY_LAKE_VIEW = 'ROOM_AMENITY_LAKE_VIEW',
    ROOM_AMENITY_LANAI = 'ROOM_AMENITY_LANAI',
    ROOM_AMENITY_JACUZZI_BATHROOM = 'ROOM_AMENITY_JACUZZI_BATHROOM',
    ROOM_AMENITY_PARTIAL_SEA_VIEW = 'ROOM_AMENITY_PARTIAL_SEA_VIEW',
    ROOM_AMENITY_JETTED_BATHTUB = 'ROOM_AMENITY_JETTED_BATHTUB',
    ROOM_AMENITY_BARBECUE_FACILITIES = 'ROOM_AMENITY_BARBECUE_FACILITIES',
    ROOM_AMENITY_BALCONY_WITH_DECK_CHAIRS = 'ROOM_AMENITY_BALCONY_WITH_DECK_CHAIRS',
    ROOM_AMENITY_THREE_TV_SETS = 'ROOM_AMENITY_THREE_TV_SETS',
    ROOM_AMENITY_BALCONY_WITH_SIDE_SEA_VIEW = 'ROOM_AMENITY_BALCONY_WITH_SIDE_SEA_VIEW',
    ROOM_AMENITY_PRIVATE_POOL = 'ROOM_AMENITY_PRIVATE_POOL',
    ROOM_AMENITY_VIEW_TO_STADIUM = 'ROOM_AMENITY_VIEW_TO_STADIUM',
    ROOM_AMENITY_AERO_MASSAGE_BATH = 'ROOM_AMENITY_AERO_MASSAGE_BATH',
    ROOM_AMENITY_BAY_VIEW = 'ROOM_AMENITY_BAY_VIEW',
    ROOM_AMENITY_VIEW_RACE_TRACK = 'ROOM_AMENITY_VIEW_RACE_TRACK',
}
//#endregion V1RoomAmenityIcon

//#region V1RoomArea
interface V1RoomArea {
    unit?: V1RoomAreaUnits;
    /**
     * * Значение площади
     *
     * @format float
     **/
    value?: number;
}
//#endregion V1RoomArea

//#region V1RoomAreaUnits
enum V1RoomAreaUnits {
    ROOM_AREA_UNITS_UNKNOWN = 'ROOM_AREA_UNITS_UNKNOWN',
    ROOM_AREA_UNITS_SQUARE_METERS = 'ROOM_AREA_UNITS_SQUARE_METERS',
}
//#endregion V1RoomAreaUnits

//#region V1RoomBedGroup
interface V1RoomBedGroup {
    /**
     * Элементы объединяются через "И", т.е. в комнате присутствуют сразу все перечисленные кровати.
     **/
    items?: Array<V1RoomBedItem>;
}
//#endregion V1RoomBedGroup

//#region V1RoomBedIcon
enum V1RoomBedIcon {
    ROOM_BED_ICON_UNKNOWN = 'ROOM_BED_ICON_UNKNOWN',
    ROOM_BED_ICON_SINGLE = 'ROOM_BED_ICON_SINGLE',
    ROOM_BED_ICON_DOUBLE = 'ROOM_BED_ICON_DOUBLE',
}
//#endregion V1RoomBedIcon

//#region V1RoomBedItem
interface V1RoomBedItem {
    icon?: V1RoomBedIcon;
    /**
     * Количество кроватей такого типа в номере
     *
     * @format int64
     **/
    quantity?: number;
}
//#endregion V1RoomBedItem

//#region V1SearchHotelsReq
interface V1SearchHotelsReq {
    analytics_data?: V1AnalyticsData;
    filter_data?: Array<V1FilterData>;
    image_params?: V1ImageParams;
    query_data?: V1QueryData;
    quick_sort?: V1QuickSorter;
}
//#endregion V1SearchHotelsReq

//#region V1SearchHotelsRsp
interface V1SearchHotelsRsp {
    bbox?: V1BoundingBox;
    detailed_filters?: V1Filters;
    /**
     * Количество отелей для текста в фильтрах "Искать цены в X отелях"
     *
     * @format int32
     **/
    found_hotel_count?: number;
    /**
     * Найденные отели
     *
     **/
    hotels?: Array<V1Hotel>;
    navigation_tokens?: V1NavigationTokens;
    /**
     * рекомендуемая пауза перед следующей итерацией поллинга
     *
     * @format int32
     **/
    next_polling_request_delay_ms?: number;
    offer_search_progress?: V1OfferSearchProgress;
    params?: V1FilterParams;
    /**
     * Ответ необходимо отбросить, если
     * Если ответ относится к более старой эпохе.
     * Если ответ относится к более старой итерации в текущей эпохе.
     * @format int64
     **/
    poll_epoch?: number;
    /**
     * Завершили ли поиск
     *
     **/
    polling_finished?: boolean;
    price_filter?: V1PriceFilter;
    /**
     * новые быстрые фильтры
     *
     **/
    quick_filters?: Array<V1QuickFilters>;
    /**
     * Контекст поиска (строка) нужен для следующих итераций поллинга
     * это строка, которая ассоциируется с данной итерацией поллинга.
     * при инициализации поиска контекст равен null. в ответ на каждую итерацию поллинга бэк возвращает заполненные данные для search_context,
     * которые необходимо передавать на следующем шаге итерации. то есть клиент использует в качестве контекста gjbcrf те данные,
     * которые вернулись на предыдущей итерации поллинга (бэк сам заботится о коллизиях и клиенту об этому думать не нужно)
     *
     **/
    search_context?: string;
    /**
     * Информация о поллинге (строка, формируемая на бэке).
     **/
    search_page_polling_id?: string;
    /**
     * Сортировки
     *
     **/
    sorters?: Array<V1QuickSorter>;
}
//#endregion V1SearchHotelsRsp

//#region V1Sort
enum V1Sort {
    SORT_UNKNOWN = 'SORT_UNKNOWN',
    SORT_RELEVANT_FIRST = 'SORT_RELEVANT_FIRST',
    SORT_PRICE_ASC = 'SORT_PRICE_ASC',
    SORT_PRICE_DESC = 'SORT_PRICE_DESC',
    SORT_HIGH_RATING_FIRST = 'SORT_HIGH_RATING_FIRST',
}
//#endregion V1Sort

//#region V1StartSearchReason
/**
 * - START_SEARCH_REASON_QUERY_BY_LOCATION: Изменились query параметры. Форма поиска или браузерный назад-вперед(в рамках страницы поиска).
 * - START_SEARCH_REASON_MAP_BOUNDS: Изменился bounds карты.
 * - START_SEARCH_REASON_NAVIGATION_TOKEN: Нажатие кнопок назад-вперед под списком.
 * - START_SEARCH_REASON_FILTERS: Применение фильтров.
 * - START_SEARCH_REASON_FILTERS_TYPE_SEARCH_TEXT: Использование поискового текстового фильтра.
 * - START_SEARCH_REASON_SORT: Изменение сортировки.
 * - START_SEARCH_REASON_MOUNT: Самый первый поиск в приложении (пользователь открыл приложение и начал искать отели).
 **/
enum V1StartSearchReason {
    START_SEARCH_REASON_UNKNOWN = 'START_SEARCH_REASON_UNKNOWN',
    START_SEARCH_REASON_QUERY_BY_LOCATION = 'START_SEARCH_REASON_QUERY_BY_LOCATION',
    START_SEARCH_REASON_MAP_BOUNDS = 'START_SEARCH_REASON_MAP_BOUNDS',
    START_SEARCH_REASON_NAVIGATION_TOKEN = 'START_SEARCH_REASON_NAVIGATION_TOKEN',
    START_SEARCH_REASON_FILTERS = 'START_SEARCH_REASON_FILTERS',
    START_SEARCH_REASON_FILTERS_TYPE_SEARCH_TEXT = 'START_SEARCH_REASON_FILTERS_TYPE_SEARCH_TEXT',
    START_SEARCH_REASON_SORT = 'START_SEARCH_REASON_SORT',
    START_SEARCH_REASON_MOUNT = 'START_SEARCH_REASON_MOUNT',
}
//#endregion V1StartSearchReason

//#region V1SuggestGroup
/**
 * Сгруппированный по типу ("регионы", "гостиницы", "вы искали" итп) раздел списка подсказок.
 **/
interface V1SuggestGroup {
    items?: Array<V1SuggestItem>;
    title?: string;
}
//#endregion V1SuggestGroup

//#region V1SuggestItem
/**
 * Подсказка направления отельной поездки.
 **/
interface V1SuggestItem {
    data?: V1SuggestItemData;
    /**
     * Идентификатор подсказки. Используется для логгирования.
     **/
    id?: string;
    /**
     * Подзаголовок подсказки, например "Россия - Краснодарский край, Сочи, Континентальный проезд, 6".
     **/
    subtitle?: string;
    /**
     * Заголовок подсказки, например "Сочи Парк Отель".
     **/
    title?: string;
    type?: V1SuggestItemType;
}
//#endregion V1SuggestItem

//#region V1SuggestItemData
/**
 * Данные, которые необходимо запоминать при переходе пользователя по подсказке.
 **/
interface V1SuggestItemData {
    hotel?: V1HotelSuggestData;
    region?: V1RegionSuggestData;
    search_params?: V1OfferSearchParams;
}
//#endregion V1SuggestItemData

//#region V1SuggestItemType
/**
 * - SUGGEST_ITEM_TYPE_INVALID: Нет типа подсказки.
 * - SUGGEST_ITEM_TYPE_REGION: Подсказка региона.
 * - SUGGEST_ITEM_TYPE_HOTEL: Подсказка отеля.
 * - SUGGEST_ITEM_TYPE_HISTORY: Подсказка на основании истории поиска.
 * - SUGGEST_ITEM_TYPE_TRIP: Подсказка на основании забронированных поездок.
 **/
enum V1SuggestItemType {
    SUGGEST_ITEM_TYPE_INVALID = 'SUGGEST_ITEM_TYPE_INVALID',
    SUGGEST_ITEM_TYPE_REGION = 'SUGGEST_ITEM_TYPE_REGION',
    SUGGEST_ITEM_TYPE_HOTEL = 'SUGGEST_ITEM_TYPE_HOTEL',
    SUGGEST_ITEM_TYPE_HISTORY = 'SUGGEST_ITEM_TYPE_HISTORY',
    SUGGEST_ITEM_TYPE_TRIP = 'SUGGEST_ITEM_TYPE_TRIP',
}
//#endregion V1SuggestItemType

//#region V1YandexPlusInfo
interface V1YandexPlusInfo {
    eligible?: boolean;
    /**
     * @format int64
     **/
    points?: number;
}
//#endregion V1YandexPlusInfo

export type {
    FilterDataList,
    HotelGeoFeature,
    HotelGeoInfo,
    HotelRubric,
    ImageSize,
    KeyphrasematchFragments,
    QueryDataPollingData,
    QuickFilterSortSortList,
    ProtobufAny,
    RuntimeError,
    TypeDate,
    V1AggregatedOfferInfo,
    V1AnalyticsData,
    V1Author,
    V1BoundingBox,
    V1CancellationInfo,
    V1Coordinates,
    V1CountersQueryData,
    V1DetailedFilter,
    V1Feature,
    V1FeatureRatingInfo,
    V1Filter,
    V1FilterBatch,
    V1FilterData,
    V1FilterInfo,
    V1FilterParams,
    V1Filters,
    V1GetHotelCountersReq,
    V1GetHotelCountersRsp,
    V1GetHotelImagesReq,
    V1GetHotelImagesRsp,
    V1GetHotelInfoReq,
    V1GetHotelInfoRsp,
    V1GetHotelOffersReq,
    V1GetHotelOffersRsp,
    V1Hotel,
    V1HotelBadge,
    V1HotelFeatureGroup,
    V1HotelID,
    V1HotelPartnerOffersInfo,
    V1HotelRoom,
    V1HotelSuggestData,
    V1HotelsOperator,
    V1HotelsSuggestReq,
    V1HotelsSuggestRsp,
    V1Image,
    V1ImageParams,
    V1ImageReview,
    V1Keyphrase,
    V1Keyphrasematch,
    V1LogHotelsSuggestSelectedReq,
    V1LogHotelsSuggestSelectedRsp,
    V1Moderation,
    V1NavigationTokens,
    V1OfferInfo,
    V1OfferSearchParams,
    V1OfferSearchProgress,
    V1OffersInfo,
    V1PagingParams,
    V1PansionInfo,
    V1Price,
    V1PriceFilter,
    V1PriceInterval,
    V1QueryData,
    V1QuickFilter,
    V1QuickFilterPrice,
    V1QuickFilterSort,
    V1QuickFilters,
    V1QuickSorter,
    V1RatingsInfo,
    V1RefundRule,
    V1RegionSuggestData,
    V1ReviewQuickFilterPhrase,
    V1ReviewQuickFilterSort,
    V1ReviewQuickSorter,
    V1ReviewRsp,
    V1ReviewsRsp,
    V1RoomAmenity,
    V1RoomAmenityGroup,
    V1RoomArea,
    V1RoomBedGroup,
    V1RoomBedItem,
    V1SearchHotelsReq,
    V1SearchHotelsRsp,
    V1SuggestGroup,
    V1SuggestItem,
    V1SuggestItemData,
    V1YandexPlusInfo,
};

export {
    HotelGeoFeatureIcon,
    V1CancellationInfoAggregate,
    V1Effect,
    V1FeatureIcon,
    V1GeoLocationStatus,
    V1HotelBadgeType,
    V1ImageSize,
    V1ModerationStatus,
    V1PansionAggregate,
    V1PansionType,
    V1PartnerId,
    V1RefundType,
    V1ReviewReactionType,
    V1ReviewSort,
    V1RoomAmenityIcon,
    V1RoomAreaUnits,
    V1RoomBedIcon,
    V1Sort,
    V1StartSearchReason,
    V1SuggestItemType,
};
