const { resolve } = require('path');
const { readdir } = require('fs/promises');
const { generate } = require('../dist');

const ROOT_PATH = resolve(__dirname, '..');
const EXAMPLES_PATH = 'examples';
const ABS_EXAMPLES_PATH = resolve(ROOT_PATH, EXAMPLES_PATH);

(async function main() {
    const examplesNames = await readdir(ABS_EXAMPLES_PATH);

    for (const name of examplesNames) {
        const examplePath = resolve(ABS_EXAMPLES_PATH, name);
        const configPath = resolve(examplePath, '.openapi.config.js');
        const config = require(configPath);

        console.log(`> Running example: ${name}`);

        await generate({
            cwd: examplePath,
            ...config,
        });
    }
})();
