import { createConfiguration, UserConfiguration } from './configuration';
import { createExecutionContext } from './execution-context';
import { renderDocuments, writeDocuments } from './fs/output';
import { loadDocuments } from './fs/read';
import { createDocumentsNodes } from './tree/document';

export async function generate(userConfiguration: UserConfiguration) {
    const configuration = createConfiguration(userConfiguration);
    const context = createExecutionContext(configuration);

    try {
        const documents = await loadDocuments(context);
        const documentNodes = createDocumentsNodes(documents, context);
        const renderedDocuments = renderDocuments(documentNodes, context);

        await writeDocuments(renderedDocuments, context);
        context.print();
    } catch (error: unknown) {
        context.catch(error);
    }
}
