import { RequestOptions } from './create-request-options-factory';

export class BaseFetchHttpClient implements BaseHttpClient {
    constructor(private options: BaseHttpClientOptions) {}

    async request<Done>({ url: path, params, ...init }: RequestOptions): Promise<Done> {
        const url = new URL(path, this.options.baseUrl ?? 'http://localhost');

        for (const [name, value] of Object.entries(params)) {
            url.searchParams.append(name, value);
        }

        const request = new Request(url, init);
        const response = await fetch(request);
        const responseAsJson = await response.json();

        if (!response.ok) {
            throw responseAsJson;
        }

        return responseAsJson;
    }
}

export interface BaseHttpClientOptions {
    baseUrl?: string;
}

export interface BaseHttpClient {
    request<Done>(options: RequestOptions): Promise<Done>;
}
