import { ExecutionContext } from '../../execution-context';
import { DocumentNode } from '../../tree/types';
import { uniq } from '../../utils/uniq';
import { findAllHelpersRequirements, HelperInfo, HelperName } from '../helpers';
import { renderApiClient } from './render-api';
import { renderEffector } from './render-effector';
import { renderEndpointsTypes } from './render-endpoints-types';
import { renderReduxClient } from './render-redux';
import { renderSharedTypes } from './render-shared-types';
import { GeneratedClientType } from './types';

export function getRequiredClients(types: GeneratedClientType[]): GeneratedClientType[] {
    return uniq(types.flatMap(type => [type, ...requiredClients[type]]));
}

export function getRequiredHelpers(types: GeneratedClientType[]): HelperInfo[] {
    return findAllHelpersRequirements(types.flatMap(type => requiredHelpers[type]));
}

export function renderClient(
    type: GeneratedClientType,
    node: DocumentNode,
    context: ExecutionContext,
) {
    return generators[type](node, context);
}

const requiredClients: Record<GeneratedClientType, GeneratedClientType[]> = {
    sharedTypes: [],
    endpointsTypes: [],
    api: ['endpointsTypes'],
    redux: ['endpointsTypes'],
    effector: ['endpointsTypes'],
    contracts: ['endpointsTypes'],
    proxy: ['endpointsTypes'],
};
const requiredHelpers: Record<GeneratedClientType, HelperName[]> = {
    contracts: [],
    endpointsTypes: [],
    sharedTypes: [],
    proxy: [],
    api: ['BaseHttpApiClient', 'BaseFetchHttpClient', 'createRequestOptionsFactory'],
    redux: ['createReduxEndpoint'],
    effector: ['requestFx', 'createEffectorEndpointEffect'],
};
const generators: Record<
    GeneratedClientType,
    (node: DocumentNode, ctx: ExecutionContext) => string
> = {
    endpointsTypes: renderEndpointsTypes,
    sharedTypes: renderSharedTypes,
    effector: renderEffector,
    redux: renderReduxClient,
    api: renderApiClient,
    proxy: () => {
        throw new Error('Not implemented yet');
    },
    contracts: () => {
        throw new Error('Not implemented yet');
    },
};
