import { getResolved } from '../../tree/reference';
import { AnyParameterNode, EndpointNode, ParameterNode, ParameterType } from '../../tree/types';
import { pascalCase } from '../../utils/normalize-string';

export const getEndpointImports = ({ display: { parametersName, responseName } }: EndpointNode) => [
    parametersName,
    responseName,
];

export const getEndpointFailedResponseTypes = ({
    responses: { failed },
    display: { responseName },
}: EndpointNode) => failed.map(node => `${responseName}${pascalCase(node.name)}`);

export const renderEndpointRequestOptionsFactory = ({
    path,
    method,
    display: { parametersName },
    parameters,
    requestBody,
}: EndpointNode) =>
    `createRequestOptionsFactory<${parametersName}>(
    ${wrapString(method)},
    ${wrapString(path)},
    ${renderParametersInPathString(parameters)},
    ${renderParametersInQueryString(parameters)},
    ${requestBody ? '"body"' : 'null'}
)`;

const renderParametersInPathString = (parameters: AnyParameterNode[]) =>
    renderParamsToArrayString(getTypedParams(parameters, 'path'));

const renderParametersInQueryString = (parameters: AnyParameterNode[]) =>
    renderParamsToArrayString(getTypedParams(parameters, 'query'));

const getTypedParams = (parameters: AnyParameterNode[], type: ParameterType) =>
    parameters.map(getResolved).filter(param => param.type === type);

const renderParamsToArrayString = (list: ParameterNode[]) =>
    wrapArray(list.map(param => wrapString(param.name)).join(', '));

const wrapString = (value: string) => `"${value}"`;
const wrapArray = (value: string) => `[${value}]`;
