export const renderJoinedParts = (parts: Array<string | number | null | undefined>) =>
    parts.filter(Boolean).join('\n');

export const renderRegion = (name: string, parts: Array<string | number | null | undefined>) =>
    renderJoinedParts([`//#region ${name}`, ...parts, `//#endregion ${name}`]);

export const renderImport = (content: string, path: string, type = false) =>
    `import ${type ? 'type ' : ''}{ ${content} } from "${path}";`;

export const renderBrackets = (value: string) => `(${value})`;

// TODO Проработать общий подход к импортам
export interface ImportDefinition {
    name: string;
    type: 'helper' | 'endpoint-type' | 'shared-type';
}
