import { renderRegion } from '../shared';
import { TypeDefinition } from './types';

export function renderTypeDefinitionsToString(definitions: TypeDefinition[]) {
    return [
        renderTypeDefinitionsListToContentString(definitions),
        renderTypeDefinitionsToExportString(definitions),
    ].join('\n\n');
}

export const renderTypeDefinitionsListToContentString = (definitions: TypeDefinition[]) =>
    definitions.map(renderTypeDefinitionToContentString).join('\n\n');

export function renderTypeDefinitionToContentString({ name, annotation, content }: TypeDefinition) {
    return renderRegion(name, [annotation, content]);
}

export function renderTypeDefinitionsToExportString(definitions: TypeDefinition[]) {
    const types = definitions
        .filter(definition => definition.type === 'type')
        .map(definition => definition.name);
    const runtime = definitions
        .filter(definition => definition.type === 'runtime')
        .map(definition => definition.name);

    return [
        types.length > 0 && `export type ${namesToString(types)}`,
        runtime.length > 0 && `export ${namesToString(runtime)}`,
    ]
        .filter(Boolean)
        .join('\n\n');
}

const namesToString = (names: string[]) => `{
    ${names.map(nameToObjectPart).join('\n')}
}`;
const nameToObjectPart = (name: string) => `  ${name},`;
