import { OpenAPIV3 } from 'openapi-types';
import { Configuration } from '../configuration';
import { createAnySchemaNode } from './schemas';
import { MediaTypeNode, MediaVariantsNode } from './types';

export function createMediaVariantsNode(
    original: Record<string, OpenAPIV3.MediaTypeObject>,
    configuration: Configuration,
): MediaVariantsNode {
    const primaryName = configuration.resolve.primaryMediaName(Object.keys(original));
    const all = Object.entries(original).map<MediaTypeNode>(([name, value]) => ({
        nodeType: 'media-type',
        original: value,
        schema: createAnySchemaNode(value.schema!, configuration),
        name,
    }));

    return {
        nodeType: 'media-variants',
        original,
        primary: all.find(node => node.name === primaryName)!,
        all,
    };
}
