import { createReferenceFactory } from './reference';
import { createAnySchemaNode } from './schemas';
import { ParameterType } from './types';

export const createParameterNode = createReferenceFactory<'parameters'>(
    (original, configuration) => {
        const schema = createAnySchemaNode(original.schema!, configuration);

        return {
            nodeType: 'parameter',
            name: original.name,
            type: original.in.trim().toLowerCase() as ParameterType,
            schema,
            original,
            virtualSchemaNode: {
                nodeType: 'schema',
                schemaType: 'object',
                index: null,
                combined: null,
                original: {},
                properties: [
                    {
                        nodeType: 'property',
                        nullable: Boolean(original.allowEmptyValue),
                        optional: !original.required,
                        value: schema,
                        name: original.name,
                    },
                ],
            },
        };
    },
);
