import { createMediaVariantsNode } from './media';
import { createReferenceFactory } from './reference';

export const createRequestBodyNode = createReferenceFactory<'requestBodies'>(
    (original, configuration) => {
        const media = createMediaVariantsNode(original.content ?? {}, configuration);

        return {
            nodeType: 'request-body',
            original,
            media,
            virtualSchemaNode: {
                nodeType: 'schema',
                schemaType: 'object',
                index: null,
                combined: null,
                original: {},
                properties: media.primary
                    ? [
                          {
                              nodeType: 'property',
                              nullable: false,
                              optional: !original.required,
                              value: media.primary.schema,
                              // TODO Добавить в конфигурацию
                              name: 'body',
                          },
                      ]
                    : [],
            },
        };
    },
);
