import { createMediaVariantsNode } from './media';
import { createReferenceFactory } from './reference';

export const createResponseNode = createReferenceFactory<'responses'>((original, configuration) => {
    const media = createMediaVariantsNode(original.content ?? {}, configuration);
    const originalSchemaExtensions = {
        description: original.description,
    };

    if (media.primary) {
        Object.assign(media.primary.schema.original, originalSchemaExtensions);
    }

    return {
        nodeType: 'response',
        original,
        success: false,
        name: '',
        media,
        virtualSchemaNode: media.primary?.schema ?? {
            nodeType: 'schema',
            schemaType: 'object',
            original: originalSchemaExtensions,
            combined: null,
            index: null,
            properties: [],
        },
    };
});
