import { join, relative } from 'path';
import { identity } from './uniq';

export const normalizeBy =
    (fn: (part: string, index: number) => string, wrap: (value: string) => string = identity) =>
    (value: string) =>
        wrap(
            value
                .split(STRING_SEPARATOR)
                .map(part => part.trim())
                .filter(Boolean)
                .map(fn)
                .join(''),
        );

export const changeFirstCaseBy = (fn: (char: string) => string) => (value: string) =>
    `${fn(value[0])}${value.slice(1)}`;

export const uppercaseFirst = changeFirstCaseBy(char => char.toUpperCase());
export const lowercaseFirst = changeFirstCaseBy(char => char.toLowerCase());

export const pascalCase = normalizeBy(uppercaseFirst);
export const camelCase = normalizeBy(uppercaseFirst, lowercaseFirst);

export const STRING_SEPARATOR = /\/|\\|\s|'|"|\.|`|[|]|_|-/;

// TODO Объединить утилиты, мешанина какая-то
export const dropExtension = (value: string) => value.replace(/\.ts$/, '');
export const relativePath = (from: string, to: string) => relative(join(from, '..'), to);
export const forceRelativePath = (path: string) => (path.startsWith('.') ? path : `./${path}`);
export const relativeTsFile = (from: string, to: string) =>
    dropExtension(forceRelativePath(relativePath(from, to)));
