export const identity = <T>(value: T) => value;

export const uniqBy = <T>(values: T[], fn: (value: T) => any) =>
    values.reduce((acc, value) => {
        if (!acc.includes(fn(value))) acc.push(value);

        return acc;
    }, [] as T[]);

export const uniqByT =
    <T>(fn: (value: T) => any) =>
    (values: T[]) =>
        uniqBy(values, fn);

export const uniq = uniqByT(identity);
