module.exports = {
    staticDirs: ['../atoms/icon/static'],
    stories: ['../**/*.stories.mdx', '../**/*.stories.@(js|jsx|ts|tsx)'],
    addons: [
        '@storybook/addon-essentials',
        {
            name: '@storybook/addon-postcss',
            options: {
                postcssLoaderOptions: {
                    postcssOptions: require('../postcss.config'),
                    implementation: require('postcss'),
                },
            },
        },
    ],
    core: {
        builder: {
            name: 'webpack5',
            options: {
                lazyCompilation: true,
                fsCache: true,
            },
        },
        disableTelemetry: true,
    },
    framework: '@storybook/react',
    features: {
        postcss: false,
        storyStoreV7: true,
        buildStoriesJson: true,
        modernInlineRender: true,
    },
    typescript: {
        check: false,
        checkOptions: {},
        reactDocgen: 'react-docgen-typescript',
        reactDocgenTypescriptOptions: {
            shouldExtractLiteralValuesFromEnum: true,
            propFilter: prop => (prop.parent ? !/node_modules/.test(prop.parent.fileName) : true),
        },
    },
};
