import { ForwardedRef, forwardRef } from 'react';
import clsx from 'clsx';

import type { ICardProps, TCardShadow } from './card.types';

export const Card = forwardRef(
    (
        { className, shadow = 'object', radius = 'l', spacing = 'm', ...props }: ICardProps,
        ref: ForwardedRef<HTMLDivElement>,
    ) => {
        return (
            <div
                ref={ref}
                {...props}
                className={clsx(
                    radiusClass[radius],
                    shadowClass[shadow],
                    spacing && spacings[spacing],
                    className,
                )}
            />
        );
    },
);

const spacings = {
    l: 'p-8',
    m: 'px-8 pt-7 pb-8',
    s: 'px-6 py-7',
};
const shadowClass: Partial<Record<TCardShadow, string>> = {
    popup: 'shadow-popup',
    object: 'shadow-object',
};
const radiusClass = {
    xs: 'rounded-xs',
    s: 'rounded-sm',
    m: 'rounded-md',
    l: 'rounded-lg',
};
