import { ReactNode } from 'react';

import { ISharedHtmlAtomProps, PropsOf } from '../../types';

export interface ICardProps
    extends ISharedHtmlAtomProps,
        Pick<PropsOf<'div'>, 'role' | 'onClick' | 'style'> {
    children?: ReactNode;
    shadow?: TCardShadow;
    radius?: TCardRadius;
    spacing?: TCardSpacing | false;
}

export type TCardSpacing = 's' | 'm' | 'l';
export type TCardRadius = 'xs' | 's' | 'm' | 'l';
export type TCardShadow = 'object' | 'popup' | 'none';
