import { Meta, Story } from '@storybook/react/types-6-0';
import { Fragment, useState } from 'react';

import { Icon } from './icon';
import type { IconProps } from './icon.types';
import { IconGroupName } from './icon.types';
import Text from '../text';
import Button from '../../molecules/button';
import { ICONS_GROUPS_LIST } from './icons.sprite.meta';

const csf: Meta = {
    title: 'atoms/Icon',
    component: Icon,
};

const info = ICONS_GROUPS_LIST.reduce(
    (acc, group) => {
        for (const name of group.items) {
            if (!acc.names.includes(name)) {
                acc.names.push(name);
                acc.groups[name] = [];
            }

            if (!acc.groups[name].includes(group.name)) {
                acc.groups[name].push(group.name);
            }
        }

        return acc;
    },
    {
        names: [] as string[],
        groups: {} as Record<string, string[]>,
    },
);

export const gallery: Story<IconProps<any>> = args => {
    const [selected, setSelected] = useState<{ group: IconGroupName; name: any } | null>(null);

    return (
        <div className="space-y-8">
            <div className="flex gap-4">
                <Text size="xl" className="sticky top-0 left-0 bg-white block py-4">
                    {selected
                        ? `Выбрано: ${selected.group} - ${selected.name}`
                        : 'Ничего не выбрано'}
                </Text>
            </div>
            {ICONS_GROUPS_LIST.map(group => (
                <Fragment key={group.name}>
                    <Text size="lg">Группа: {group.name}</Text>

                    <div className="flex flex-wrap gap-4">
                        {group.items.map(name => (
                            <Button
                                size="xl"
                                key={name}
                                theme={
                                    selected?.group === group.name && selected?.name === name
                                        ? 'attention'
                                        : 'secondary'
                                }
                                startNode={
                                    <Icon {...args} group={group.name as any} name={name as any} />
                                }
                                onClick={() => setSelected({ group: group.name as any, name })}
                            />
                        ))}
                    </div>
                </Fragment>
            ))}
        </div>
    );
};

gallery.storyName = 'Все иконки';
gallery.args = {};

export const sizeVariants: Story<IconProps<any>> = args => (
    <table className="text-left">
        <thead>
            <tr>
                <th className="p-4">Имя</th>
                {ICONS_GROUPS_LIST.map(group => (
                    <th className="p-4 text-center" key={group.name}>
                        {group.name}
                    </th>
                ))}
            </tr>
        </thead>
        <tbody>
            {info.names.map(name => (
                <tr key={name} className="border-b border-grey-light">
                    <td className="px-4 py-1">{name}</td>
                    {ICONS_GROUPS_LIST.map(group => (
                        <td className="px-4 py-1" key={group.name}>
                            {info.groups[name] && (
                                <Icon
                                    {...args}
                                    group={group.name as any}
                                    name={name as any}
                                    style={{
                                        fontSize: `${group.name}px`,
                                    }}
                                />
                            )}
                        </td>
                    ))}
                </tr>
            ))}
        </tbody>
    </table>
);

sizeVariants.storyName = 'Возможные размеры';
sizeVariants.args = {};

const Template: Story<IconProps<any>> = args => <Icon {...args} />;

export const sandbox = Template.bind({});

sandbox.storyName = 'Sandbox';
sandbox.args = {
    name: 'CovidShild',
};

export default csf;
