import clsx from 'clsx';
import { ForwardedRef, forwardRef } from 'react';

import type { IconProps } from './icon.types';
import { IconGroupName } from './icon.types';

export const Icon = forwardRef(
    <Group extends IconGroupName = '16'>(
        {
            group = '16' as Group,
            name,
            className,
            viewBox,
            testId = `sprite-icon-${name}`,
            fileName = `/sprite/${group}.svg`,
            ...props
        }: IconProps<Group>,
        ref: ForwardedRef<SVGSVGElement>,
    ) => (
        <svg
            className={clsx(
                'select-none fill-current w-[1em] h-[1em] inline-block text-inherit',
                className,
            )}
            data-qa={testId}
            ref={ref}
            viewBox={viewBox}
            focusable="false"
            aria-hidden={true}
            {...props}
        >
            <use xlinkHref={`${fileName}#${name}`} />
        </svg>
    ),
);
