import { SVGProps } from 'react';

import { ISharedHtmlAtomProps } from '../../types';

import { IIconsSpriteMap } from './icons.sprite.meta';

export interface IconProps<Group extends IconGroupName>
    extends Pick<SVGProps<SVGSVGElement>, 'viewBox' | 'style'>,
        ISharedHtmlAtomProps {
    name: IIconsSpriteMap[Group];
    group?: Group;
    fileName?: string;
}

export type IconGroupName = Extract<keyof IIconsSpriteMap, string>;
