import { Meta, Story } from '@storybook/react/types-6-0';

import { ListBoxItem } from './list-box-item';
import type { IListBoxItemProps } from './list-box-item.types';
import Icon from '../icon';

const csf: Meta = {
    title: 'atoms/ListBoxItem',
    component: ListBoxItem,
};

export const gallery: Story<IListBoxItemProps> = args => (
    <div className="w-60">
        <ListBoxItem reserveStartNodeSpace selected startNode={<Icon name="Call" />} {...args}>
            Цианид калия и счастье
        </ListBoxItem>
        <ListBoxItem reserveStartNodeSpace {...args}>
            Метанол
        </ListBoxItem>
        <ListBoxItem reserveStartNodeSpace {...args}>
            Батрахотоксин
        </ListBoxItem>
        <ListBoxItem reserveStartNodeSpace disabled {...args}>
            Тренажер
        </ListBoxItem>
    </div>
);

gallery.storyName = 'Gallery';
gallery.args = {};

const Template: Story<IListBoxItemProps> = args => <ListBoxItem {...args} />;

export const sandbox = Template.bind({});

sandbox.storyName = 'Sandbox';
sandbox.args = {
    children: 'Элемент списка',
};

export default csf;
